/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.metrics.panel.PageTemplateFactory;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;
import oracle.dbtools.raptor.metrics.viewer.AbstractPanelAdapter;
import oracle.ide.controls.Toolbar;

public class MetricsToolbarAdapter
extends AbstractPanelAdapter {
    private final PageTemplateFactory<Region> factory;
    private volatile JFXPanel fxPanel;
    private StackPane sceneRoot;
    private Scene scene;
    private final String connectionName;
    private final String toolbarLayout;
    private final List<ObjectAction> actions;

    public MetricsToolbarAdapter(PageTemplateFactory<Region> pageTemplateFactory, String string, String string2, List<ObjectAction> list) {
        super(new BorderLayout());
        this.factory = pageTemplateFactory;
        this.connectionName = string;
        this.toolbarLayout = string2;
        this.actions = list;
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
    }

    public String getToolbarLayout() {
        return this.toolbarLayout;
    }

    public List<ObjectAction> getActions() {
        return this.actions;
    }

    public void openToolbarUI(Toolbar toolbar) {
        this.setPreferredSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(0, 0));
        Platform.runLater(() -> this.prepareToolbarUI(toolbar));
    }

    private void prepareToolbarUI(final Toolbar toolbar) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ConnectionName", this.connectionName);
        hashMap.put("Snapshot", false);
        PanelTemplate<Region> panelTemplate = this.factory.newPageTemplate(hashMap);
        final TemplateInstance<Region> templateInstance = panelTemplate.newPanel();
        if (templateInstance != null) {
            this.sceneRoot = new StackPane(new Node[]{(Node)templateInstance.getRootObject()}){
                private boolean populated;
                {
                    super(nodeArray);
                    this.populated = false;
                }

                protected void layoutChildren() {
                    super.layoutChildren();
                    Bounds bounds = ((Region)templateInstance.getRootObject()).getLayoutBounds();
                    double d = bounds.getWidth();
                    double d2 = bounds.getHeight();
                    if (d > 0.0 && d2 > 0.0) {
                        SwingUtilities.invokeLater(() -> {
                            Dimension dimension = new Dimension((int)d, (int)d2);
                            MetricsToolbarAdapter.this.setPreferredSize(dimension);
                            MetricsToolbarAdapter.this.setMaximumSize(dimension);
                            MetricsToolbarAdapter.this.setMinimumSize(dimension);
                            if (!this.populated) {
                                toolbar.add(Box.createHorizontalGlue());
                                toolbar.add((Component)MetricsToolbarAdapter.this);
                                this.populated = true;
                            }
                            toolbar.revalidate();
                            toolbar.repaint();
                        });
                    }
                }
            };
            this.scene = new Scene((Parent)this.sceneRoot);
            this.fxPanel.setScene(this.scene);
            this.sceneRoot.applyCss();
            this.sceneRoot.layout();
        }
    }

    public void closeToolbarUI() {
        Platform.runLater(() -> this.sceneRoot.getChildren().clear());
    }
}

