/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.metrics.dataobject.VarBoolean;
import oracle.dbtools.raptor.metrics.dataobject.VarObject;
import oracle.dbtools.raptor.metrics.panel.LocalsService;

public abstract class MetricsPanelCommand {
    private final ObjectAction action;
    private Supplier<Boolean> operation;
    private ObservableBooleanValue disabledProperty;
    private boolean disabled;

    MetricsPanelCommand(ObjectAction objectAction) {
        this.action = objectAction;
    }

    void initialize(LocalsService localsService) {
        String string = this.action.getClassArgs();
        String[] stringArray = string.split("\\s+");
        switch (stringArray.length) {
            case 1: {
                this.initOperation(localsService, stringArray[0]);
                break;
            }
            case 2: {
                this.initOperation(localsService, stringArray[0]);
                this.initDisabledProperty(localsService, stringArray[1]);
                break;
            }
            default: {
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "invalid format for args in command ''{0}''", this.getCommandName());
            }
        }
        this.updateDisabled();
    }

    public String getCommandName() {
        return this.action.getCommandName();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void invoke() {
        if (this.operation != null) {
            Platform.runLater(() -> this.operation.get());
        }
    }

    protected abstract void onUpdateDisabled();

    private void updateDisabled() {
        boolean bl = this.disabledProperty != null ? this.operation == null || this.disabledProperty.get() : this.operation == null;
        SwingUtilities.invokeLater(() -> {
            if (this.disabled != bl) {
                this.disabled = bl;
                this.onUpdateDisabled();
            }
        });
    }

    private void initOperation(LocalsService localsService, String string) {
        String[] stringArray = string.split("\\s*\\.\\s*");
        switch (stringArray.length) {
            case 1: {
                this.operation = localsService.get(Supplier.class, stringArray[0]);
                if (this.operation != null) break;
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target object not found ''{0}''", stringArray[0]);
                break;
            }
            case 2: {
                Object object = localsService.get(stringArray[0]);
                if (object == null) {
                    Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target object not found ''{0}''", stringArray[0]);
                    break;
                }
                if (object instanceof VarObject) {
                    VarObject varObject = (VarObject)object;
                    if (varObject.getValue() != null) {
                        this.initReflectiveOperation(varObject.getValue(), stringArray[1]);
                        break;
                    }
                    varObject.valueProperty().addListener(observable -> {
                        this.initReflectiveOperation(varObject.getValue(), stringArray[1]);
                        this.updateDisabled();
                    });
                    break;
                }
                this.initReflectiveOperation(object, stringArray[1]);
                break;
            }
            default: {
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "invalid format for operation ''{0}'' in command ''{1}''", new Object[]{string, this.getCommandName()});
            }
        }
    }

    private void initReflectiveOperation(Object object, String string) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target method not found ''{0}''", string);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "reflection error:", securityException);
        }
        Method method2 = method;
        this.operation = () -> {
            try {
                if (method2 != null) {
                    method2.invoke(object, new Object[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.WARNING, "command failed:", invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "reflection error:", exception);
            }
            return true;
        };
    }

    private void initDisabledProperty(LocalsService localsService, String string) {
        String[] stringArray = string.split("\\s*\\.\\s*");
        switch (stringArray.length) {
            case 1: {
                VarBoolean varBoolean = localsService.get(VarBoolean.class, stringArray[0]);
                if (varBoolean == null) {
                    Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target object not found ''{0}''", stringArray[0]);
                    break;
                }
                this.disabledProperty = varBoolean.valueProperty();
                break;
            }
            case 2: {
                Object object;
                boolean bl3;
                String string2 = stringArray[0].trim();
                boolean bl4 = bl3 = !string2.isEmpty() && string2.charAt(0) == '!';
                if (bl3) {
                    string2 = string2.substring(1).trim();
                }
                if ((object = localsService.get(string2)) == null) {
                    Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target object not found ''{0}''", stringArray[0]);
                } else {
                    try {
                        Method method = object.getClass().getMethod(stringArray[1], new Class[0]);
                        Object object2 = method.invoke(object, new Object[0]);
                        if (object2 instanceof ObservableBooleanValue) {
                            this.disabledProperty = (ObservableBooleanValue)object2;
                        } else {
                            Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "property method does not return boolean observable ''{0}''", stringArray[1]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target method not found ''{0}''", stringArray[1]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "target method raised exception '" + stringArray[1] + "'", invocationTargetException);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                        Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "reflection error:", exception);
                    }
                }
                if (this.disabledProperty == null || !bl3) break;
                this.disabledProperty = Bindings.not((ObservableBooleanValue)this.disabledProperty);
                break;
            }
            default: {
                Logger.getLogger(MetricsPanelCommand.class.getName()).log(Level.SEVERE, "invalid format for operation ''{0}'' in command ''{1}''", new Object[]{string, this.getCommandName()});
            }
        }
        if (this.disabledProperty != null) {
            this.disabledProperty.addListener((observableValue, bl, bl2) -> this.updateDisabled());
        }
    }
}

