/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

class SQLValueConverter
extends ValueConverter {
    SQLValueConverter() {
    }

    public BigDecimal booleanToRaw(Object object) {
        return object != null ? new BigDecimal((Boolean)object != false ? 1 : 0) : null;
    }

    @Override
    public Boolean rawToBoolean(Object object) {
        return object != null ? Boolean.valueOf(((BigDecimal)object).longValue() != 0L) : null;
    }

    public BigDecimal realToRaw(Object object) {
        return object != null ? new BigDecimal((Double)object) : null;
    }

    @Override
    public Double rawToReal(Object object) {
        return object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
    }

    public BigDecimal integerToRaw(Object object) {
        return object != null ? new BigDecimal((Long)object) : null;
    }

    @Override
    public Long rawToInteger(Object object) {
        return object != null ? Long.valueOf(((BigDecimal)object).longValue()) : null;
    }

    public Timestamp dateTimeToRaw(Object object) {
        return object != null ? Timestamp.valueOf((LocalDateTime)object) : null;
    }

    @Override
    public LocalDateTime rawToDateTime(Object object) {
        LocalDateTime localDateTime = null;
        if (object != null) {
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                localDateTime = timestamp.toLocalDateTime();
            } else if (object instanceof Date) {
                Timestamp timestamp = new Timestamp(((Date)object).getTime());
                localDateTime = timestamp.toLocalDateTime();
            } else if (object instanceof TIMESTAMP) {
                try {
                    TIMESTAMP tIMESTAMP = (TIMESTAMP)object;
                    Timestamp timestamp = tIMESTAMP.timestampValue();
                    localDateTime = timestamp.toLocalDateTime();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            } else if (object instanceof TIMESTAMPLTZ) {
                TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)object;
                byte[] byArray = tIMESTAMPLTZ.getBytes();
                int n = (byArray[0] - 100) * 100 + byArray[1] - 100;
                byte by = byArray[2];
                byte by2 = byArray[3];
                byte by3 = byArray[4];
                int n2 = byArray[5] - 1;
                int n3 = byArray[6] - 1;
                int n4 = ((byArray[7] & 0xFF) << 24) + ((byArray[8] & 0xFF) << 16) + ((byArray[9] & 0xFF) << 8) + (byArray[10] & 0xFF);
                localDateTime = LocalDateTime.of(n, by, (int)by2, (int)by3, n2, n3, n4);
            }
        }
        return localDateTime;
    }
}

