/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.panel.Formatter;

class TextFormatter
extends Formatter {
    TextFormatter() {
    }

    @Override
    protected String formatImpl(String string, Map<String, String> map, Object ... objectArray) {
        String string2;
        String string3 = null;
        String string4 = objectArray.length > 0 ? objectArray[0].toString() : "";
        String string5 = string2 = map != null ? map.get("break") : null;
        if (string2 == null) {
            string2 = "\n";
        }
        if (string.startsWith("bp")) {
            if (string.length() > 2) {
                int[] nArray = this.extractIndices(string.substring(2));
                string3 = this.insertDelimitedBreaks(string4, ".,;:#~^&$_()[]{} \n\t", nArray[0], nArray[1], string2);
            }
        } else if (string.startsWith("bw")) {
            if (string.length() > 2) {
                int[] nArray = this.extractIndices(string.substring(2));
                string3 = this.insertDelimitedBreaks(string4, " \n\t", nArray[0], nArray[1], string2);
            }
        } else if (string.startsWith("b")) {
            if (string.length() > 1) {
                int n = this.extractIndex(string.substring(1), 1, 80);
                string3 = this.insertFixedBreaks(string4, n, string2);
            }
        } else if (string.startsWith("x") && string.length() > 1) {
            int n = this.extractIndex(string.substring(1), 5, 80);
            string3 = this.truncate(string4, n);
        }
        if (string3 == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "invalid text format : ''{0}''", string);
            string3 = string4;
        }
        return string3;
    }

    private String insertDelimitedBreaks(String string, String string2, int n, int n2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        int n4 = 0;
        block0: for (int i = 0; i < n3; ++i) {
            if (n4 < n) {
                stringBuilder.append(string.charAt(i));
                ++n4;
                continue;
            }
            if (n4 < n2) {
                char c = string.charAt(i);
                stringBuilder.append(c);
                ++n4;
                int n5 = string2.length();
                for (int j = 0; j < n5; ++j) {
                    char c2 = string2.charAt(j);
                    if (c != c2) continue;
                    stringBuilder.append(string3);
                    n4 = 0;
                    continue block0;
                }
                continue;
            }
            stringBuilder.append(string3);
            stringBuilder.append(string.charAt(i));
            n4 = 1;
        }
        return stringBuilder.toString();
    }

    private String insertFixedBreaks(String string, int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        for (int i = n; i < n2; i += n) {
            stringBuilder.append(string.substring(n3, i));
            stringBuilder.append(string2);
            n3 = i;
        }
        if (n3 < n2) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    private int[] extractIndices(String string) {
        int[] nArray = new int[2];
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 1: {
                nArray[0] = this.extractIndex(stringArray[0], 1, 80);
                nArray[1] = -1;
                break;
            }
            case 2: {
                nArray[0] = this.extractIndex(stringArray[0], 1, 80);
                nArray[1] = this.extractIndex(stringArray[1], nArray[0] + 1, -1);
                break;
            }
            default: {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "invalid index list specified: ''{0}''", string);
                nArray[0] = 80;
                nArray[1] = -1;
            }
        }
        return nArray;
    }

    private int extractIndex(String string, int n, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
            if (n3 < n) {
                n3 = n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "invalid index specified: '" + string + "'", numberFormatException);
            n3 = n2;
        }
        return n3;
    }

    private String truncate(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, n - 4));
            stringBuilder.append(" ...");
            return stringBuilder.toString();
        }
        return string;
    }
}

