/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.observable;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.observable.Key;

class Row
implements DXRow {
    private final Key key;
    private final Map<String, ObjectProperty<Comparable<?>>> columnMap = new HashMap();

    Row(DXTableChanges.Row row) {
        for (String string : row.getCellNames()) {
            this.columnMap.put(string, (ObjectProperty<Comparable<?>>)new SimpleObjectProperty((Object)row.getCellValue(string, Comparable.class)));
        }
        this.key = new Key(row.getRowKey().getKeyCellNames(), this.columnMap);
    }

    @Override
    public DXKey getKey() {
        return this.key;
    }

    @Override
    public Set<String> getNames() {
        return this.columnMap.keySet();
    }

    @Override
    public <T extends Comparable<?>> ObjectProperty<T> get(String string, Class<T> clazz) {
        ObjectProperty<Comparable<?>> objectProperty = this.columnMap.get(string);
        if (objectProperty != null) {
            Object object = objectProperty.get();
            if (object == null || clazz.isAssignableFrom(object.getClass())) {
                return objectProperty;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Type mismatch for column ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), object.getClass().getName()});
        }
        return null;
    }
}

