/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.listener;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.item.TableItemType;

public class DXTableChanges {
    private final List<Row> addedRows;
    private final List<Row> changedRows;
    private final List<Key> removedRowKeys;

    public DXTableChanges(List<Row> list, List<Row> list2, List<Key> list3) {
        this.addedRows = list;
        this.changedRows = list2;
        this.removedRowKeys = list3;
    }

    public List<Row> getAddedRows() {
        return this.addedRows;
    }

    public List<Row> getChangedRows() {
        return this.changedRows;
    }

    public List<Key> getRemovedRowKeys() {
        return this.removedRowKeys;
    }

    public static class Row {
        private final Key rowKey;
        private final Map<String, Object> cellMap;

        public Row(Key key, Map<String, Object> map) {
            this.rowKey = key;
            this.cellMap = map;
        }

        public Key getRowKey() {
            return this.rowKey;
        }

        public Set<String> getCellNames() {
            return this.cellMap.keySet();
        }

        public <T> T getCellValue(String string, Class<T> clazz) {
            Object object = this.cellMap.get(string);
            if (object != null) {
                if (clazz.isAssignableFrom(object.getClass())) {
                    return (T)object;
                }
                Logger.getLogger(DXTableChanges.class.getName()).log(Level.WARNING, "Type mismatch for cell ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), object.getClass().getName()});
            }
            return null;
        }
    }

    public static class Key
    implements Comparable<Key> {
        private final TableItemType itemType;
        private final Map<String, Object> cellMap;

        public Key(TableItemType tableItemType, Map<String, Object> map) {
            this.itemType = tableItemType;
            this.cellMap = map;
        }

        public List<String> getKeyCellNames() {
            return this.itemType.getKeyNames();
        }

        public <T> T getCellValue(String string, Class<T> clazz) {
            Object object = this.cellMap.get(string);
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            Logger.getLogger(DXTableChanges.class.getName()).log(Level.WARNING, "Type mismatch for cell ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{string, clazz.getName(), object.getClass().getName()});
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return key.cellMap.equals(this.cellMap);
        }

        public int hashCode() {
            int n = 7;
            n = 11 * n + Objects.hashCode(this.cellMap);
            return n;
        }

        @Override
        public int compareTo(Key key) {
            for (String string : this.itemType.getKeyNames()) {
                Comparable comparable = this.getCellValue(string, Comparable.class);
                Comparable comparable2 = key.getCellValue(string, Comparable.class);
                if (comparable == null) {
                    if (comparable2 == null) continue;
                    return -1;
                }
                if (comparable2 == null) {
                    return 1;
                }
                int n = comparable.compareTo(comparable2);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

