/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.item.PrimitiveItemType;

abstract class PrimitiveItemInstance<T extends Comparable<?>>
extends ItemInstance {
    private static final Comparable<?> initValue = object -> -1;
    private T value = initValue;

    PrimitiveItemInstance(URI uRI) {
        super(uRI);
    }

    @Override
    public abstract PrimitiveItemType<T> getItemType();

    protected T getChangeObject() {
        return this.value;
    }

    @Override
    protected void update(ValueConverter valueConverter, DataMap dataMap) {
        List<String> list = this.getItemType().getMapTo();
        List<Object> list2 = dataMap.getColumnValue(list);
        if (list2 != null && list2.size() > 0) {
            Object object = null;
            try {
                object = this.getValue(valueConverter, list2.get(0));
            }
            catch (Exception exception) {
                this.getLogger().log(Level.WARNING, "Unable to convert '" + list + " from type '" + list2.get(0).getClass().getName() + "' to type '" + ((PrimitiveItemType)this.getItemType()).getChangeClass().getName() + "'", exception);
            }
            boolean bl = object != null ? !object.equals(this.value) : this.value != null;
            this.value = object;
            if (bl) {
                this.markChanged();
            }
        } else {
            this.getLogger().log(Level.WARNING, "Zero length array received for column ''{0}''", list);
        }
    }

    protected T getValue(ValueConverter valueConverter, Object object) {
        return ((PrimitiveItemType)this.getItemType()).rawToGeneric(valueConverter, object);
    }
}

