/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javax.imageio.ImageIO;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="panelTemplate")
public class Snapshot
extends AbstractGenerationElement {
    private final ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty = new SimpleObjectProperty((Object)this, "panelTemplate");
    private final DoubleProperty widthProperty = new SimpleDoubleProperty((Object)this, "width", 400.0);
    private final DoubleProperty heightProperty = new SimpleDoubleProperty((Object)this, "height", 300.0);
    private final StringProperty imageProperty = new SimpleStringProperty((Object)this, "image");
    private final BooleanProperty disableStylesheetInheritanceProperty = new SimpleBooleanProperty((Object)this, "disableStylesheetInheritance");

    public PanelTemplate<Parent> getPanelTemplate() {
        return (PanelTemplate)this.panelTemplateProperty.get();
    }

    public void setPanelTemplate(PanelTemplate<Parent> panelTemplate) {
        this.panelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty() {
        return this.panelTemplateProperty;
    }

    public double getWidth() {
        return this.widthProperty.get();
    }

    public void setWidth(double d) {
        this.widthProperty.set(d);
    }

    public DoubleProperty widthProperty() {
        return this.widthProperty;
    }

    public double getHeight() {
        return this.heightProperty.get();
    }

    public void setHeight(double d) {
        this.heightProperty.set(d);
    }

    public DoubleProperty heightProperty() {
        return this.heightProperty;
    }

    public String getImage() {
        return (String)this.imageProperty.get();
    }

    public void setImage(String string) {
        this.imageProperty.set((Object)string);
    }

    public StringProperty imageProperty() {
        return this.imageProperty;
    }

    public boolean isDisableStylesheetInheritance() {
        return this.disableStylesheetInheritanceProperty.get();
    }

    public void setDisableStylesheetInheritance(boolean bl) {
        this.disableStylesheetInheritanceProperty.set(bl);
    }

    public BooleanProperty disableStylesheetInheritanceProperty() {
        return this.disableStylesheetInheritanceProperty;
    }

    @Override
    boolean isSynchronous() {
        return false;
    }

    @Override
    void generate(Consumer<GenerationResult> consumer) {
        String string = this.getGenerationSettings().getAttributes().get(String.class, "FilePath");
        if (string == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "'FilePath' must be specified when calling Snapshot");
            return;
        }
        File file = new File(string);
        File file2 = new File(file.getParentFile(), this.getImage());
        File file3 = file2.getParentFile();
        file3.mkdir();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Snapshot", true);
        TemplateInstance<Parent> templateInstance = this.getPanelTemplate().newPanel(hashMap);
        Node node = (Node)templateInstance.getRootObject();
        Scene scene = new Scene((Parent)new StackPane(new Node[]{node}), this.getWidth(), this.getHeight());
        if (!this.isDisableStylesheetInheritance()) {
            scene.getStylesheets().addAll(this.findSceneStylesheets());
        }
        BooleanExpression booleanExpression = templateInstance.availableProperty();
        booleanExpression.addListener(observable -> {
            if (booleanExpression.get()) {
                Platform.runLater(() -> {
                    WritableImage writableImage = new WritableImage((int)this.getWidth(), (int)this.getHeight());
                    scene.snapshot(writableImage);
                    try {
                        ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)writableImage, null), "png", file2);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, iOException);
                    }
                    consumer.accept(new GenerationResult(true, ""));
                });
            }
        });
    }

    private List<String> findSceneStylesheets() {
        Parent parent;
        ArrayList<String> arrayList = new ArrayList<String>();
        Parent parent2 = null;
        for (Context context = this.getGenerationSettings().getContext(); context != null; context = context.getParentContext()) {
            parent = context.getRootObject(Parent.class);
            if (parent == null) continue;
            arrayList.addAll((Collection<String>)parent.getStylesheets());
            parent2 = parent;
        }
        if (parent2 != null) {
            parent = parent2.getScene();
            arrayList.addAll((Collection<String>)parent.getStylesheets());
        }
        return arrayList;
    }
}

