/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.ListExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.facet.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetHelper;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.facet.TreeTableCellFactory;
import oracle.dbtools.raptor.metrics.facet.TreeTableFeatureSet;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundListDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public class TreeTableViewMonitor
extends AbstractTableMonitor<TreeTableColumn<DXRow, Object>, TreeTableCell<DXRow, Object>, TreeTableFeatureSet> {
    private TreeTableView<DXRow> tableView;
    private final Map<Comparable<?>, TreeItem<DXRow>> treeItems = new HashMap();
    private TableFeatureSetHelper<TreeTableFeatureSet> featureSetHelper;
    private final StringProperty idColumnNameProperty = new SimpleStringProperty((Object)this, "idColumnName");
    private final StringProperty parentIdColumnNameProperty = new SimpleStringProperty((Object)this, "parentIdColumnName");
    private final BooleanProperty defaultExpandedProperty = new SimpleBooleanProperty((Object)this, "defaultExpanded", true);
    private final ObservableList<TableFeatureSetSelector<TreeTableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();

    public TreeTableViewMonitor() {
        this.init(new Listener());
    }

    public String getIdColumnName() {
        return (String)this.idColumnNameProperty.get();
    }

    public void setIdColumnName(String string) {
        this.idColumnNameProperty.set((Object)string);
    }

    public StringProperty idColumnNameProperty() {
        return this.idColumnNameProperty;
    }

    public String getParentIdColumnName() {
        return (String)this.parentIdColumnNameProperty.get();
    }

    public void setParentIdColumnName(String string) {
        this.parentIdColumnNameProperty.set((Object)string);
    }

    public StringProperty parentIdColumnNameProperty() {
        return this.parentIdColumnNameProperty;
    }

    public boolean isDefaultExpanded() {
        return this.defaultExpandedProperty.get();
    }

    public void setDefaultExpanded(boolean bl) {
        this.defaultExpandedProperty.set(bl);
    }

    public BooleanProperty defaultExpandedProperty() {
        return this.defaultExpandedProperty;
    }

    @Override
    public ObservableList<TableFeatureSetSelector<TreeTableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    public TreeTableView<DXRow> getTableView() {
        return this.tableView;
    }

    @Override
    public Class<?> getBindToClass() {
        return TreeTableView.class;
    }

    @Override
    protected DXRow getRow(TreeTableCell<DXRow, Object> treeTableCell) {
        TreeItem treeItem;
        TreeTableRow treeTableRow;
        DXRow dXRow = null;
        int n = treeTableCell.getIndex();
        Object object = treeTableCell.getItem();
        if (n >= 0 && object != null && (treeTableRow = treeTableCell.getTreeTableRow()) != null && (treeItem = treeTableRow.getTreeItem()) != null) {
            dXRow = (DXRow)treeItem.getValue();
        }
        return dXRow;
    }

    @Override
    protected TreeTableColumn<DXRow, Object> getColumn(TreeTableCell<DXRow, Object> treeTableCell) {
        return treeTableCell.getTableColumn();
    }

    protected TreeTableCellFactory<TreeTableCell<DXRow, Object>> getCellFactory(TreeTableColumn<DXRow, Object> treeTableColumn) {
        TreeTableCellFactory treeTableCellFactory = null;
        Callback callback = treeTableColumn.getCellFactory();
        if (callback instanceof TreeTableCellFactory) {
            treeTableCellFactory = (TreeTableCellFactory)callback;
        }
        return treeTableCellFactory;
    }

    private void addRow(TreeTableView<DXRow> treeTableView, DXRow dXRow) {
        TreeTableFeatureSet treeTableFeatureSet2;
        Comparable comparable = (Comparable)dXRow.get(this.getIdColumnName()).get();
        TreeItem treeItem = this.treeItems.get(comparable);
        if (treeItem == null) {
            treeItem = new TreeItem();
            this.treeItems.put(comparable, (TreeItem<DXRow>)treeItem);
        }
        boolean bl = (treeTableFeatureSet2 = this.featureSetHelper.find(dXRow, null, treeTableFeatureSet -> true)) != null && treeTableFeatureSet2.getExpanded() != null ? treeTableFeatureSet2.getExpanded().booleanValue() : this.isDefaultExpanded();
        treeItem.setExpanded(bl);
        treeItem.setValue((Object)dXRow);
        Comparable comparable2 = (Comparable)dXRow.get(this.getParentIdColumnName()).get();
        if (comparable2 == null) {
            if (treeTableView.getRoot() == null) {
                treeTableView.setRoot(treeItem);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "tree table already has root node: item with ID ''{0}''ignored", comparable);
            }
        } else {
            TreeItem treeItem2 = this.treeItems.get(comparable2);
            if (treeItem2 == null) {
                treeItem2 = new TreeItem();
                this.treeItems.put(comparable2, (TreeItem<DXRow>)treeItem2);
            }
            ObservableList observableList = treeItem2.getChildren();
            int n = -1;
            int n2 = 0;
            for (TreeItem treeItem3 : observableList) {
                Comparable comparable3 = (Comparable)((DXRow)treeItem3.getValue()).get(this.getIdColumnName()).get();
                if (comparable.compareTo(comparable3) < 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                observableList.add(treeItem);
            } else {
                observableList.add(n, treeItem);
            }
        }
    }

    private void removeRow(TreeTableView<DXRow> treeTableView, DXRow dXRow) {
        Comparable comparable = (Comparable)dXRow.get(this.getIdColumnName()).get();
        TreeItem<DXRow> treeItem = this.treeItems.get(comparable);
        if (treeItem != null) {
            ArrayList arrayList = new ArrayList();
            this.listSubTree(treeItem, arrayList);
            treeItem.setValue(null);
            for (Comparable comparable2 : arrayList) {
                this.treeItems.remove(comparable2);
            }
            if (treeItem.getParent() != null) {
                treeItem.getParent().getChildren().remove(treeItem);
            } else {
                treeTableView.setRoot(null);
            }
        }
    }

    private void listSubTree(TreeItem<DXRow> treeItem, List<Comparable<?>> list) {
        list.add((Comparable)((DXRow)treeItem.getValue()).get(this.getIdColumnName()).get());
        for (TreeItem treeItem2 : treeItem.getChildren()) {
            this.listSubTree((TreeItem<DXRow>)treeItem2, list);
        }
    }

    private void bindTreeTableColumn(TreeTableColumn<DXRow, ?> treeTableColumn) {
        TreeTableColumn<DXRow, ?> treeTableColumn2 = treeTableColumn;
        Callback callback = treeTableColumn2.getCellFactory();
        if (callback instanceof AbstractCellFactory) {
            AbstractCellFactory abstractCellFactory = (AbstractCellFactory)callback;
            treeTableColumn2.setCellValueFactory(cellDataFeatures -> ((DXRow)cellDataFeatures.getValue().getValue()).get(abstractCellFactory.getValueColumn()));
        }
    }

    private void showSelectedCellContextMenu(ContextMenuEvent contextMenuEvent) {
        ObservableList observableList = this.tableView.getSelectionModel().getSelectedCells();
        if (!observableList.isEmpty()) {
            double d;
            double d2;
            TreeTablePosition treeTablePosition = (TreeTablePosition)observableList.get(0);
            TreeTableCellFactory<TreeTableCell<DXRow, Object>> treeTableCellFactory = this.getCellFactory((TreeTableColumn<DXRow, Object>)treeTablePosition.getTableColumn());
            TreeTableCell<DXRow, Object> treeTableCell = treeTableCellFactory.getCell(treeTablePosition.getRow());
            if (contextMenuEvent != null) {
                d2 = contextMenuEvent.getScreenX();
                d = contextMenuEvent.getScreenY();
            } else {
                Bounds bounds = treeTableCell.getBoundsInLocal();
                Point2D point2D = treeTableCell.localToScreen(0.0, bounds.getHeight());
                d2 = point2D.getX();
                d = point2D.getY();
            }
            this.showContextMenu(treeTableCell.getContextMenu(), treeTableCell, d2, d);
        }
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            TreeTableViewMonitor.this.tableView = context.getLinkedTarget(TreeTableView.class, TreeTableViewMonitor.this);
            TreeTableViewMonitor.this.tableView.getSelectionModel().setCellSelectionEnabled(TreeTableViewMonitor.this.isCellSelectionEnabled());
            if (TreeTableViewMonitor.this.tableView != null) {
                ObservableList observableList;
                ListExpression listExpression2;
                for (ListExpression listExpression2 : TreeTableViewMonitor.this.tableView.getColumns()) {
                    observableList = TreeTableViewMonitor.this.getCellFactory((TreeTableColumn<DXRow, Object>)listExpression2);
                    observableList.initCellFactory(TreeTableViewMonitor.this);
                }
                TreeTableViewMonitor.this.tableView.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuEvent -> {
                    if (!contextMenuEvent.isKeyboardTrigger()) {
                        TreeTableViewMonitor.this.showSelectedCellContextMenu((ContextMenuEvent)contextMenuEvent);
                    }
                });
                TreeTableViewMonitor.this.tableView.setOnKeyReleased(keyEvent -> {
                    if (TreeTableViewMonitor.this.isShowContextMenuEvent((KeyEvent)keyEvent)) {
                        TreeTableViewMonitor.this.showSelectedCellContextMenu(null);
                    }
                });
                BoundListDataObject boundListDataObject = TreeTableViewMonitor.this.getItem();
                listExpression2 = boundListDataObject.valueProperty();
                listExpression2.addListener(change -> {
                    while (change.next()) {
                        for (DXRow dXRow : change.getRemoved()) {
                            TreeTableViewMonitor.this.removeRow(TreeTableViewMonitor.this.tableView, dXRow);
                        }
                        for (DXRow dXRow : change.getAddedSubList()) {
                            TreeTableViewMonitor.this.addRow(TreeTableViewMonitor.this.tableView, dXRow);
                        }
                    }
                });
                TreeTableViewMonitor.this.featureSetHelper = new TableFeatureSetHelper(new List[]{TreeTableViewMonitor.this.featureSetSelectors});
                observableList = TreeTableViewMonitor.this.tableView.getColumns();
                for (TreeTableColumn treeTableColumn : observableList) {
                    TreeTableViewMonitor.this.bindTreeTableColumn(treeTableColumn);
                }
            }
        }
    }
}

