/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.facet.ChartMonitor;
import oracle.dbtools.raptor.metrics.facet.PointAxisProperties;
import oracle.dbtools.raptor.metrics.facet.SeriesAxisProperties;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public abstract class TimeSeriesMonitor
extends ChartMonitor {
    private final ObjectProperty<Duration> samplingIntervalProperty = new SimpleObjectProperty((Object)this, "samplingInterval", (Object)Duration.seconds((double)10.0));
    private XYChart<Number, Number> chart;
    private final ObjectProperty<ObservableList<XYChart.Series<Number, Number>>> data = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private SeriesAxisProperties timeAxisProperties;
    private PointAxisProperties valueAxisProperties;
    private Timeline timeline;
    private boolean firstSample;
    private List<SeriesSource> seriesSources;
    private ObservableBooleanValue seriesAvailable;

    public Duration getSamplingInterval() {
        return (Duration)this.samplingIntervalProperty.get();
    }

    public void setSamplingInterval(Duration duration) {
        this.samplingIntervalProperty.set((Object)duration);
    }

    public ObjectProperty<Duration> samplingIntervalProperty() {
        return this.samplingIntervalProperty;
    }

    public boolean isRunning() {
        return this.timeline != null;
    }

    protected abstract List<SeriesSource> getSeriesSources();

    private void beginSampling(List<SeriesSource> list) {
        this.seriesSources = list;
        ObservableList observableList = (ObservableList)this.data.get();
        observableList.clear();
        this.chart.dataProperty().bind(this.data);
        for (SeriesSource seriesSource : list) {
            XYChart.Series series = new XYChart.Series();
            series.setName(seriesSource.getSeriesName());
            observableList.add((Object)series);
        }
        KeyFrame keyFrame = new KeyFrame(this.getSamplingInterval(), actionEvent -> this.onSamplingIntervalExpired(), new KeyValue[0]);
        this.timeline = new Timeline(new KeyFrame[]{keyFrame});
        this.timeline.setCycleCount(-1);
        Platform.runLater(() -> {
            if (this.timeline != null && this.timeline.getStatus() != Animation.Status.RUNNING) {
                this.firstSample = true;
                this.timeline.playFromStart();
                this.onSamplingIntervalExpired();
            }
        });
    }

    private void onSamplingIntervalExpired() {
        double[] dArray;
        if (!this.isRunning()) {
            return;
        }
        if (this.timeAxisProperties != null) {
            dArray = this.timeAxisProperties.update();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] dArray3 = dArray;
        double d = dArray3[0];
        double d2 = dArray3[1];
        int n = this.seriesSources.size();
        if (n > 0) {
            ObservableList observableList = (ObservableList)this.data.get();
            if (this.firstSample) {
                this.firstSample = false;
                for (int i = 0; i < n; ++i) {
                    Number number = this.getItemValue(i);
                    XYChart.Series series = (XYChart.Series)observableList.get(i);
                    series.getData().add((Object)new XYChart.Data((Object)(d2 - this.getSamplingInterval().toMillis()), (Object)number));
                    series.getData().add((Object)new XYChart.Data((Object)d2, (Object)number));
                }
            }
            ObservableList observableList2 = ((XYChart.Series)observableList.get(0)).getData();
            while (observableList2.size() > 2 && ((Number)((XYChart.Data)observableList2.get(1)).getXValue()).doubleValue() < d) {
                for (int i = 0; i < n; ++i) {
                    ((XYChart.Series)observableList.get(i)).getData().remove(0);
                }
            }
            for (int i = 0; i < n; ++i) {
                ((XYChart.Series)observableList.get(i)).getData().add((Object)new XYChart.Data((Object)d2, (Object)this.getItemValue(i)));
            }
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MIN_VALUE;
            if (this.chart instanceof StackedAreaChart) {
                for (Object object : ((XYChart.Series)observableList.get(0)).getData()) {
                    double d5 = ((Number)object.getYValue()).doubleValue();
                    if (!(d5 < d3)) continue;
                    d3 = d5;
                }
                int n2 = -1;
                for (XYChart.Series series : observableList) {
                    ObservableList observableList3 = series.getData();
                    int n3 = observableList3.size();
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
                for (int i = 0; i < n2; ++i) {
                    double d6 = 0.0;
                    for (XYChart.Series series : observableList) {
                        ObservableList observableList4 = series.getData();
                        d6 += ((Number)((XYChart.Data)observableList4.get(i)).getYValue()).doubleValue();
                    }
                    if (!(d6 > d4)) continue;
                    d4 = d6;
                }
            } else {
                for (XYChart.Series series : observableList) {
                    ObservableList observableList5 = series.getData();
                    for (XYChart.Data data : observableList5) {
                        double d7 = ((Number)data.getYValue()).doubleValue();
                        if (d7 < d3) {
                            d3 = d7;
                        }
                        if (!(d7 > d4)) continue;
                        d4 = d7;
                    }
                }
            }
            if (this.valueAxisProperties != null) {
                this.valueAxisProperties.update(d3, d4);
            }
        }
    }

    private Number getItemValue(int n) {
        Number number = this.seriesSources.get(n).getValue();
        if (number == null) {
            number = 0.0;
        }
        return number;
    }

    private void monitorSeriesStyles() {
        ((ObservableList)this.data.get()).addListener(change -> {
            while (change.next()) {
                for (XYChart.Series series : change.getAddedSubList()) {
                    if (series.getNode() != null) {
                        this.addSeriesStyle(series.getNode(), series.getName());
                        this.addLegendStyle(this.chart);
                        this.monitorDataStyles((XYChart.Series<Number, Number>)series);
                        continue;
                    }
                    series.nodeProperty().addListener((observableValue, node, node2) -> {
                        this.addSeriesStyle((Node)node2, series.getName());
                        this.addLegendStyle(this.chart);
                        this.monitorDataStyles((XYChart.Series<Number, Number>)series);
                    });
                }
            }
        });
    }

    private void monitorDataStyles(XYChart.Series<Number, Number> series) {
        ((ObservableList)series.dataProperty().get()).addListener(change -> {
            while (change.next()) {
                for (XYChart.Data data : change.getAddedSubList()) {
                    if (data.getNode() != null) {
                        this.addSeriesStyle(data.getNode(), series.getName());
                        continue;
                    }
                    data.nodeProperty().addListener((observableValue, node, node2) -> this.addSeriesStyle(data.getNode(), series.getName()));
                }
            }
        });
    }

    private void addLegendStyle(XYChart<Number, Number> xYChart) {
        Platform.runLater(() -> {
            for (Node node : xYChart.lookupAll(".chart-legend-item")) {
                ObservableList observableList;
                Label label = (Label)node;
                Node node2 = label.getGraphic();
                String string = this.getStyleName(label.getText());
                if (string == null || (observableList = node2.getStyleClass()).contains(string)) continue;
                node2.getStyleClass().add((Object)string);
            }
        });
    }

    private void addSeriesStyle(Node node, String string) {
        Parent parent;
        String string2 = this.getStyleName(string);
        if (string2 == null) {
            return;
        }
        if (node instanceof Parent) {
            parent = (Parent)node;
            for (Node node2 : parent.getChildrenUnmodifiable()) {
                this.addSeriesStyle(node2, string2);
            }
        }
        parent = node.getStyleClass();
        parent.add((Object)string2);
        parent.addListener(arg_0 -> TimeSeriesMonitor.lambda$addSeriesStyle$7((ObservableList)parent, string2, arg_0));
    }

    private String getStyleName(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string.replace(" ", "-").replace("/", "").toLowerCase();
    }

    private static /* synthetic */ void lambda$addSeriesStyle$7(ObservableList observableList, String string, ListChangeListener.Change change) {
        if (!observableList.contains((Object)string)) {
            observableList.add((Object)string);
        }
    }

    protected static class SeriesSource {
        private final String seriesName;
        private final ObservableValue<? extends Number> value;

        protected SeriesSource(String string, ObservableValue<? extends Number> observableValue) {
            this.seriesName = string;
            this.value = observableValue;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public Number getValue() {
            return (Number)this.value.getValue();
        }
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            XYChart xYChart = context.getLinkedTarget(XYChart.class, TimeSeriesMonitor.this);
            if (xYChart == null || !(xYChart.getXAxis() instanceof NumberAxis) || !(xYChart.getYAxis() instanceof NumberAxis)) {
                throw new IllegalArgumentException("ChartData can only be associated with XYChart<Number,Number>");
            }
            TimeSeriesMonitor.this.chart = xYChart;
            TimeSeriesMonitor.this.timeAxisProperties = TimeSeriesMonitor.this.findAndInitializeAxisProperties(SeriesAxisProperties.class, context, (NumberAxis)TimeSeriesMonitor.this.chart.getXAxis());
            TimeSeriesMonitor.this.valueAxisProperties = TimeSeriesMonitor.this.findAndInitializeAxisProperties(PointAxisProperties.class, context, (NumberAxis)TimeSeriesMonitor.this.chart.getYAxis());
        }

        @Override
        public void onOpen(Context context) {
            TimeSeriesMonitor.this.monitorSeriesStyles();
            TimeSeriesMonitor.this.seriesAvailable = null;
            for (DataObject<?> dataObject : TimeSeriesMonitor.this.getDataObjects(context)) {
                if (TimeSeriesMonitor.this.seriesAvailable == null) {
                    TimeSeriesMonitor.this.seriesAvailable = dataObject.availableProperty();
                    continue;
                }
                TimeSeriesMonitor.this.seriesAvailable = Bindings.and((ObservableBooleanValue)TimeSeriesMonitor.this.seriesAvailable, (ObservableBooleanValue)dataObject.availableProperty());
            }
            if (TimeSeriesMonitor.this.seriesAvailable != null) {
                TimeSeriesMonitor.this.seriesAvailable.addListener(observable -> TimeSeriesMonitor.this.beginSampling(TimeSeriesMonitor.this.getSeriesSources()));
            }
        }

        @Override
        public void onClose(Context context) {
            if (TimeSeriesMonitor.this.chart.dataProperty().isBound()) {
                TimeSeriesMonitor.this.chart.dataProperty().unbind();
            }
            if (TimeSeriesMonitor.this.timeline != null && TimeSeriesMonitor.this.timeline.getStatus() == Animation.Status.RUNNING) {
                TimeSeriesMonitor.this.timeline.stop();
            }
            TimeSeriesMonitor.this.timeline = null;
            TimeSeriesMonitor.this.seriesSources = null;
        }
    }
}

