/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import oracle.dbtools.raptor.metrics.facet.AbstractTableFeatureSet;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.observable.DXRow;

class TableFeatureSetHelper<T extends AbstractTableFeatureSet> {
    private final List<TableFeatureSetSelector<T>> selectors = new ArrayList<TableFeatureSetSelector<T>>();

    TableFeatureSetHelper(List<TableFeatureSetSelector<T>> ... listArray) {
        for (List<TableFeatureSetSelector<T>> list : listArray) {
            this.selectors.addAll(list);
        }
    }

    boolean containsCandidateFeatureSets(Function<T, Boolean> function) {
        for (TableFeatureSetSelector<T> tableFeatureSetSelector : this.selectors) {
            for (AbstractTableFeatureSet abstractTableFeatureSet : tableFeatureSetSelector.getFeatureSets()) {
                if (!function.apply(abstractTableFeatureSet).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    T find(DXRow dXRow, String string, Function<T, Boolean> function) {
        for (TableFeatureSetSelector<T> tableFeatureSetSelector : this.selectors) {
            String string2 = tableFeatureSetSelector.getSelectorColumn();
            if (string2 == null) {
                string2 = string;
            }
            if (string2 == null) continue;
            Comparable comparable = (Comparable)dXRow.get(string2).get();
            for (AbstractTableFeatureSet abstractTableFeatureSet : tableFeatureSetSelector.getFeatureSets()) {
                if (!Objects.equals(comparable, abstractTableFeatureSet.getSelectorValue()) || !function.apply(abstractTableFeatureSet).booleanValue()) continue;
                return (T)abstractTableFeatureSet;
            }
        }
        return null;
    }
}

