/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.HashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Pagination;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

public class PaginationMonitor
implements Monitor {
    private TemplateInstance<Parent> panelInstance;
    private final StringProperty styleClassProperty = new SimpleStringProperty((Object)this, "styleClass");
    private final ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty = new SimpleObjectProperty((Object)this, "panelTemplate");

    public PaginationMonitor() {
        this.init(new Listener());
    }

    public String getStyleClass() {
        return (String)this.styleClassProperty.get();
    }

    public void setStyleClass(String string) {
        this.styleClassProperty.set((Object)string);
    }

    public StringProperty styleClassProperty() {
        return this.styleClassProperty;
    }

    public PanelTemplate<Parent> getPanelTemplate() {
        return (PanelTemplate)this.panelTemplateProperty.get();
    }

    public void setPanelTemplate(PanelTemplate<Parent> panelTemplate) {
        this.panelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty() {
        return this.panelTemplateProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return Pagination.class;
    }

    private Node createPanel(int n) {
        this.panelInstance = null;
        PanelTemplate<Parent> panelTemplate = this.getPanelTemplate();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("pageNo", n);
        this.panelInstance = panelTemplate.newPanel(hashMap);
        if (this.panelInstance != null) {
            String string = this.getStyleClass();
            if (string != null) {
                this.panelInstance.getRootObject().getStyleClass().add((Object)string);
            }
            this.panelInstance.getContext().setDataStreamEnabled(true);
            Node node = (Node)this.panelInstance.getRootObject();
            return node;
        }
        return null;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            Pagination pagination = context.getLinkedTarget(Pagination.class, PaginationMonitor.this);
            pagination.setPageFactory(n -> PaginationMonitor.this.createPanel((int)n));
        }

        @Override
        public void onClose(Context context) {
            PaginationMonitor.this.panelInstance = null;
        }
    }
}

