/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.ColorAdjust;
import oracle.dbtools.raptor.metrics.facet.Augmentor;
import oracle.dbtools.raptor.metrics.facet.ChangeIndicator;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.SnapshotAttribute;

public class ConnectionIndicator
implements Augmentor {
    private ObservableBooleanValue connectedValue;
    private ChangeListener<Boolean> connectedListener;

    public ConnectionIndicator() {
        this.init(new Listener());
    }

    @Override
    public Class<?> getBindToClass() {
        return Node.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return ConnectionIndicator.class;
    }

    private void traverseTree(Context context, Node node) {
        ObservableBooleanValue observableBooleanValue;
        ChangeIndicator changeIndicator = context.getLinkedSource(ChangeIndicator.class, node);
        if (changeIndicator != null) {
            if (this.connectedValue == null) {
                this.connectedValue = changeIndicator.getConnectedValue();
            } else {
                observableBooleanValue = changeIndicator.getConnectedValue();
                if (observableBooleanValue != null) {
                    this.connectedValue = Bindings.and((ObservableBooleanValue)this.connectedValue, (ObservableBooleanValue)changeIndicator.getConnectedValue());
                }
            }
        }
        if (node instanceof Parent) {
            observableBooleanValue = (Parent)node;
            for (Node node2 : observableBooleanValue.getChildrenUnmodifiable()) {
                this.traverseTree(context, node2);
            }
        }
    }

    private void onConnected(Context context) {
        ColorAdjust colorAdjust = null;
        if (!this.connectedValue.get()) {
            colorAdjust = new ColorAdjust(0.0, 0.0, 0.4, 0.0);
        }
        context.getLinkedTarget(Node.class, this).setEffect(colorAdjust);
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            if (!SnapshotAttribute.get(context)) {
                Node node = context.getLinkedTarget(Node.class, ConnectionIndicator.this);
                for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    if (context.getLinkedSource(ConnectionIndicator.class, parent) == null) continue;
                    Logger.getLogger(ConnectionIndicator.class.getName()).log(Level.WARNING, "nested connection indicator found");
                }
                Platform.runLater(() -> {
                    ConnectionIndicator.this.traverseTree(context, node);
                    if (ConnectionIndicator.this.connectedValue != null) {
                        ConnectionIndicator.this.onConnected(context);
                        ConnectionIndicator.this.connectedListener = (observableValue, bl, bl2) -> ConnectionIndicator.this.onConnected(context);
                        ConnectionIndicator.this.connectedValue.addListener(ConnectionIndicator.this.connectedListener);
                    }
                });
            }
        }

        @Override
        public void onClose(Context context) {
            if (ConnectionIndicator.this.connectedValue != null && ConnectionIndicator.this.connectedListener != null) {
                ConnectionIndicator.this.connectedValue.removeListener(ConnectionIndicator.this.connectedListener);
            }
            ConnectionIndicator.this.connectedValue = null;
            ConnectionIndicator.this.connectedListener = null;
        }
    }
}

