/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableView;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.facet.ButtonCellHelper;
import oracle.dbtools.raptor.metrics.facet.TreeTableCellFactory;
import oracle.dbtools.raptor.metrics.observable.DXRow;

public class ButtonTreeCellFactory
extends TreeTableCellFactory<TreeTableCell<DXRow, Object>> {
    private final ButtonCellHelper<TableColumnBase<?, Object>, TreeTableCell<DXRow, Object>> helper = new ButtonCellHelper<TableColumnBase<?, Object>, TreeTableCell<DXRow, Object>>(){

        @Override
        void selectCell(TreeTableCell<DXRow, Object> treeTableCell) {
            TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = treeTableCell.getTreeTableView().getSelectionModel();
            treeTableViewSelectionModel.clearAndSelect(treeTableCell.getTreeTableRow().getIndex(), (TableColumnBase)treeTableCell.getTableColumn());
        }
    };

    public ButtonTreeCellFactory() {
        this.init(new Listener());
    }

    public String getEnabledColumn() {
        return (String)this.helper.enabledColumnProperty().get();
    }

    public void setEnabledColumn(String string) {
        this.helper.enabledColumnProperty().set((Object)string);
    }

    public StringProperty enabledColumnProperty() {
        return this.helper.enabledColumnProperty();
    }

    public String getText() {
        return (String)this.helper.textProperty().get();
    }

    public void setText(String string) {
        this.helper.textProperty().set((Object)string);
    }

    public StringProperty textProperty() {
        return this.helper.textProperty();
    }

    public String getImagePath() {
        return (String)this.helper.imagePathProperty().get();
    }

    public void setImagePath(String string) {
        this.helper.imagePathProperty().set((Object)string);
    }

    public StringProperty imagePathProperty() {
        return this.helper.imagePathProperty();
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.helper.onActionProperty().get();
    }

    public void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.helper.onActionProperty().set(eventHandler);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.helper.onActionProperty();
    }

    @Override
    protected TreeTableCell<DXRow, Object> createCell() {
        final Button button = this.helper.createButton(this.getContext().getClassLoader());
        return new TreeTableCell<DXRow, Object>(){

            public void updateItem(Object object, boolean bl) {
                super.updateItem(object, bl);
                ButtonTreeCellFactory.this.updateCellText(this, bl);
                this.setGraphic((Node)(ButtonTreeCellFactory.this.helper.isEnabled(ButtonTreeCellFactory.this.getRow(this)) ? button : null));
                ButtonTreeCellFactory.this.updateCellTooltip(this, bl);
                ButtonTreeCellFactory.this.helper.updateButtonTooltip(this, button);
            }
        };
    }

    @Override
    protected boolean useValueColumnAsDefaultTextColumn() {
        return true;
    }

    protected class Listener
    extends AbstractCellFactory.Listener {
        protected Listener() {
        }
    }
}

