/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.facet.AbstractTableFeatureSet;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.BoundListDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;

@DefaultProperty(value="item")
public abstract class AbstractTableMonitor<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>, F extends AbstractTableFeatureSet>
implements Monitor {
    private final ObjectProperty<BoundListDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "contextMenu");
    private final BooleanProperty cellSelectionEnabledProperty = new SimpleBooleanProperty((Object)this, "cellSelectionEnabled");
    private final BooleanProperty keyboardContextMenuDisabledProperty = new SimpleBooleanProperty((Object)this, "keyboardContextMenuDisabled");

    public BoundListDataObject getItem() {
        return (BoundListDataObject)this.itemProperty.get();
    }

    public void setItem(BoundListDataObject boundListDataObject) {
        this.itemProperty.set((Object)boundListDataObject);
    }

    public ObjectProperty<BoundListDataObject> itemProperty() {
        return this.itemProperty;
    }

    public boolean isCellSelectionEnabled() {
        return this.cellSelectionEnabledProperty.get();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.cellSelectionEnabledProperty.set(bl);
    }

    public BooleanProperty cellSelectionEnabledProperty() {
        return this.cellSelectionEnabledProperty;
    }

    public boolean isKeyboardContextMenuDisabled() {
        return this.keyboardContextMenuDisabledProperty.get();
    }

    public void setKeyboardContextMenuDisabled(boolean bl) {
        this.keyboardContextMenuDisabledProperty.set(bl);
    }

    public BooleanProperty keyboardContextMenuDisabledProperty() {
        return this.keyboardContextMenuDisabledProperty;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    public abstract ObservableList<TableFeatureSetSelector<F>> getFeatureSetSelectors();

    public abstract Control getTableView();

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList((DataObject)this.itemProperty.get());
    }

    protected abstract DXRow getRow(L var1);

    protected abstract C getColumn(L var1);

    protected abstract AbstractCellFactory<C, L> getCellFactory(C var1);

    protected void showContextMenu(ContextMenu contextMenu, L l, double d, double d2) {
        if (contextMenu == null) {
            contextMenu = this.getContextMenu();
        }
        contextMenu.setUserData(l);
        contextMenu.show(l, d, d2);
    }

    protected boolean isShowContextMenuEvent(KeyEvent keyEvent) {
        return !this.isKeyboardContextMenuDisabled() && keyEvent.getCode() == KeyCode.F10 && keyEvent.isAltDown() && keyEvent.isControlDown();
    }
}

