/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.facet.AbstractTableFeatureSet;
import oracle.dbtools.raptor.metrics.facet.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.facet.CellChangeIndicator;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSet;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetHelper;
import oracle.dbtools.raptor.metrics.facet.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Formatter;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.TemplateObject;

public abstract class AbstractCellFactory<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>>
implements Callback<C, L>,
TemplateObject {
    private final StringProperty valueColumnProperty = new SimpleStringProperty((Object)this, "valueColumn");
    private final StringProperty textColumnProperty = new SimpleStringProperty((Object)this, "textColumn");
    private final StringProperty textFormatProperty = new SimpleStringProperty((Object)this, "textFormat", "%s");
    private final StringProperty tooltipColumnProperty = new SimpleStringProperty((Object)this, "tooltipColumn");
    private final StringProperty tooltipFormatProperty = new SimpleStringProperty((Object)this, "tooltipFormat", "%s");
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "contextMenu");
    private final ObservableList<TableFeatureSetSelector<TableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();
    private Control tableView;
    private boolean cacheInitialized = false;
    private List<String> cachedTextColumns;
    private String cachedTooltipFormat;
    private List<String> cachedTooltipColumns;
    private TableFeatureSetHelper<AbstractTableFeatureSet> featureSetHelper;
    private boolean translateTextValues;
    private Context context;

    public String getValueColumn() {
        return (String)this.valueColumnProperty.get();
    }

    public void setValueColumn(String string) {
        this.valueColumnProperty.set((Object)string);
    }

    public StringProperty valueColumnProperty() {
        return this.valueColumnProperty;
    }

    public String getTextFormat() {
        return (String)this.textFormatProperty.get();
    }

    public void setTextFormat(String string) {
        this.textFormatProperty.set((Object)string);
    }

    public StringProperty textFormatProperty() {
        return this.textFormatProperty;
    }

    public String getTextColumn() {
        return (String)this.textColumnProperty.get();
    }

    public void setTextColumn(String string) {
        this.textColumnProperty.set((Object)string);
    }

    public StringProperty textColumnProperty() {
        return this.textColumnProperty;
    }

    public String getTooltipFormat() {
        return (String)this.tooltipFormatProperty.get();
    }

    public void setTooltipFormat(String string) {
        this.tooltipFormatProperty.set((Object)string);
    }

    public StringProperty tooltipFormatProperty() {
        return this.tooltipFormatProperty;
    }

    public String getTooltipColumn() {
        return (String)this.tooltipColumnProperty.get();
    }

    public void setTooltipColumn(String string) {
        this.tooltipColumnProperty.set((Object)string);
    }

    public StringProperty tooltipColumnProperty() {
        return this.tooltipColumnProperty;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    public ObservableList<TableFeatureSetSelector<TableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    public L call(C c) {
        Object l = this.createCell();
        this.ensureCacheInitialized();
        this.ensureTooltipsInitialized(l);
        this.initCell(l);
        CellChangeIndicator cellChangeIndicator = this.context.getLinkedTarget(CellChangeIndicator.class, this.tableView);
        if (cellChangeIndicator != null) {
            l.itemProperty().addListener((observableValue, object, object2) -> cellChangeIndicator.onCellUpdate((IndexedCell<?>)l));
            l.indexProperty().addListener((observableValue, number, number2) -> cellChangeIndicator.onCellUpdate((IndexedCell<?>)l));
        }
        return l;
    }

    public String getValueAsText(L l) {
        String string = null;
        String string2 = this.getTextFormat();
        DXRow dXRow = this.getRow(l);
        if (dXRow != null) {
            Object object;
            ObjectProperty<Comparable<?>> objectProperty = dXRow.get(this.getValueColumn());
            Object object2 = object = objectProperty != null ? objectProperty.get() : null;
            if (object != null) {
                string = string2 != null ? Formatter.format(string2, object) : object.toString();
            }
            if (this.translateTextValues) {
                string = this.translateTextValue(dXRow, string);
            }
        }
        return string;
    }

    public String getColumnText(L l) {
        String string = null;
        String string2 = this.getTextFormat();
        DXRow dXRow = this.getRow(l);
        if (dXRow != null && string2 != null && this.cachedTextColumns != null) {
            Object[] objectArray = new Object[this.cachedTextColumns.size()];
            for (int i = 0; i < this.cachedTextColumns.size(); ++i) {
                ObjectProperty<Comparable<?>> objectProperty = dXRow.get(this.cachedTextColumns.get(i));
                Object object = objectProperty != null ? objectProperty.get() : null;
                objectArray[i] = object != null && object instanceof String && this.translateTextValues ? this.translateTextValue(this.getRow(l), object.toString()) : object;
            }
            string = Formatter.format(string2, objectArray);
        }
        return string;
    }

    public String getTooltipText(L l) {
        String string = null;
        if (this.cachedTooltipFormat != null) {
            Object[] objectArray = new Object[this.cachedTooltipColumns.size()];
            for (int i = 0; i < this.cachedTooltipColumns.size(); ++i) {
                String string2 = this.cachedTooltipColumns.get(i);
                Object object = this.getRow(l).get(string2).get();
                objectArray[i] = object != null && object instanceof String && this.translateTextValues ? this.translateTextValue(this.getRow(l), object.toString()) : object;
            }
            string = Formatter.format(this.cachedTooltipFormat, objectArray);
        }
        return string;
    }

    protected Context getContext() {
        return this.context;
    }

    protected abstract L createCell();

    protected void initCell(L l) {
    }

    protected abstract boolean useValueColumnAsDefaultTextColumn();

    protected List<String> getSecondaryChangeColumns() {
        return Collections.emptyList();
    }

    protected void updateCellText(L l, boolean bl) {
        if (bl) {
            l.setText(null);
        } else {
            String string = this.getColumnText(l);
            if (string == null && this.useValueColumnAsDefaultTextColumn()) {
                string = this.getValueAsText(l);
            }
            l.setText(string != null ? string.replace('\n', ' ') : null);
        }
    }

    protected void updateCellTooltip(L l, boolean bl) {
        this.ensureTooltipsInitialized(l);
        Tooltip tooltip = l.getTooltip();
        if (tooltip != null) {
            if (bl) {
                l.setTooltip(null);
            } else {
                tooltip.setText(this.getTooltipText(l));
            }
        }
    }

    protected abstract DXRow getRow(L var1);

    protected abstract int getRowIndex(L var1);

    protected abstract int getSelectedIndex(L var1);

    protected abstract L getCell(int var1);

    void initCellFactory(AbstractTableMonitor<?, ?, ?> abstractTableMonitor) {
        this.tableView = abstractTableMonitor.getTableView();
        this.featureSetHelper = new TableFeatureSetHelper(new List[]{this.featureSetSelectors, abstractTableMonitor.getFeatureSetSelectors()});
        this.translateTextValues = this.featureSetHelper.containsCandidateFeatureSets(abstractTableFeatureSet -> abstractTableFeatureSet.getLabel() != null);
    }

    ContextMenu getContextMenu(L l) {
        AbstractTableFeatureSet abstractTableFeatureSet2 = this.featureSetHelper.find(this.getRow(l), this.getValueColumn(), abstractTableFeatureSet -> abstractTableFeatureSet.getContextMenu() != null);
        ContextMenu contextMenu = abstractTableFeatureSet2 != null ? abstractTableFeatureSet2.getContextMenu() : this.getContextMenu();
        return contextMenu;
    }

    private String translateTextValue(DXRow dXRow, String string) {
        AbstractTableFeatureSet abstractTableFeatureSet2 = this.featureSetHelper.find(dXRow, this.getValueColumn(), abstractTableFeatureSet -> abstractTableFeatureSet.getSelectorValue() != null);
        return abstractTableFeatureSet2 != null ? abstractTableFeatureSet2.getLabel() : string;
    }

    private void ensureCacheInitialized() {
        if (!this.cacheInitialized) {
            String string = this.getTextColumn();
            if (string != null) {
                this.cachedTextColumns = Arrays.asList(string.trim().split("\\s*,\\s*"));
            }
            this.cachedTooltipFormat = this.getTooltipFormat();
            if (this.cachedTooltipFormat != null) {
                String string2;
                String string3 = this.getTooltipColumn();
                this.cachedTooltipColumns = string3 != null ? Arrays.asList(string3.trim().split("\\s*,\\s*")) : (this.cachedTextColumns != null ? this.cachedTextColumns : ((string2 = this.getValueColumn()) != null ? Collections.singletonList(string2) : Collections.emptyList()));
            }
            this.cacheInitialized = true;
        }
    }

    private void ensureTooltipsInitialized(L l) {
        if (this.cachedTooltipFormat != null && l.getTooltip() == null) {
            Tooltip tooltip = new Tooltip();
            tooltip.setWrapText(true);
            tooltip.setMaxWidth(500.0);
            l.setTooltip(tooltip);
        }
    }

    protected abstract class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            AbstractCellFactory.this.context = context;
        }
    }
}

