/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.OperationAutomaton;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.RunnableInstance;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.metrics.listener.OperationChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class OperationInstance
extends RunnableInstance {
    private final OperationAutomaton automaton;

    protected OperationInstance(OperationType operationType, SourceInstance sourceInstance, Map<String, String> map, DXOperationCallback dXOperationCallback) {
        super(operationType, sourceInstance, map);
        this.automaton = new OperationAutomaton(this, dXOperationCallback);
    }

    @Override
    public abstract OperationType getRunnableType();

    OperationAutomaton getAutomaton() {
        return this.automaton;
    }

    @Override
    void start(Context context, List<InstanceProperty<?>> list) {
        super.start(context, list);
        this.getAutomaton().start();
    }

    void invoke() {
        this.getAutomaton().invoke();
    }

    protected abstract void invoke(Map<String, Object> var1);

    @Override
    void remove() {
        super.remove();
        this.getSource().removeOperation(this.getPath());
        this.getContext().getActivityListenerService().addEngineObjectChange(this, ChangeType.REMOVE);
    }

    @Override
    protected OperationChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new OperationChange(changeType, this.getId(), this.getRunnableType().getTypeId(), this.getSource().getId(), this.isRunning(), this.getLastRunElapsedTime(), this.getLastRunCPUTime(), this.getLastRunException(), list);
    }
}

