/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.BooleanMetaProperty;
import oracle.dbtools.raptor.metrics.engine.ContainerTypeObject;
import oracle.dbtools.raptor.metrics.engine.DataTransformer;
import oracle.dbtools.raptor.metrics.engine.DoubleMetaProperty;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.RunnableType;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.TypeProperty;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.JobTypeChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class JobType
extends RunnableType {
    private final Map<String, ItemType> itemTypeMap = new HashMap<String, ItemType>();
    private ContainerTypeObject.Property<Double> minimumIntervalProperty;
    private ContainerTypeObject.Property<Boolean> disabledProperty;
    private DataTransformer transformer;

    protected JobType() {
    }

    public DataTransformer getTransformer() {
        return this.transformer;
    }

    public Set<String> getItemTypeNames() {
        return this.itemTypeMap.keySet();
    }

    public ItemType getItemType(String string) {
        return this.itemTypeMap.get(string);
    }

    public <T extends ItemType> T getItemType(String string, Class<T> clazz) {
        ItemType itemType = this.itemTypeMap.get(string);
        if (itemType != null && clazz.isAssignableFrom(itemType.getClass())) {
            return (T)itemType;
        }
        return null;
    }

    @Override
    public String getCategoryName() {
        return "Job";
    }

    protected Map<String, ItemType> itemTypeMap() {
        return this.itemTypeMap;
    }

    ContainerTypeObject.Property<Double> getMinimumInterval() {
        return this.minimumIntervalProperty;
    }

    ContainerTypeObject.Property<Boolean> getDisabled() {
        return this.disabledProperty;
    }

    @Override
    protected void enumerateProperties(List<TypeProperty<?>> list) {
        if (this.minimumIntervalProperty != null) {
            list.add(this.minimumIntervalProperty);
        }
        list.add(this.disabledProperty);
    }

    JobInstance newJob(SourceInstance sourceInstance, String string) {
        JobInstance jobInstance = sourceInstance.newJob(string);
        if (jobInstance != null) {
            jobInstance.start(this.getContext(), this.createInstanceProperties(jobInstance));
        }
        return jobInstance;
    }

    JobPartition newPartition(JobInstance jobInstance, Map<String, String> map) {
        return new JobPartition(jobInstance, map);
    }

    @Override
    JobInstance findInstance(ObjectManager objectManager, Handle handle) {
        SourceInstance sourceInstance = objectManager.getEnclosingSourceInstance(handle);
        if (sourceInstance != null) {
            return sourceInstance.getJob(handle.getPath());
        }
        return null;
    }

    void setHardDefaultDisabled(boolean bl) {
        this.disabledProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Boolean>(new BooleanMetaProperty(this.getClass(), "disabled", MetricsResources.getString("METRICS_PROPERTY_DISABLED"), bl));
    }

    void setHardDefaultMinimumInterval(double d) {
        if (d >= 0.0) {
            this.minimumIntervalProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Double>(new DoubleMetaProperty(this.getClass(), "minimumInterval", MetricsResources.getString("METRICS_PROPERTY_MINIMUM_JOB_INTERVAL"), d));
        }
    }

    void setTransformerClass(DataTransformer dataTransformer) {
        this.transformer = dataTransformer;
    }

    void setItemTypes(List<ItemType> list) {
        for (ItemType itemType : list) {
            this.itemTypeMap.put(itemType.getPath(), itemType);
        }
    }

    @Override
    protected JobTypeChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new JobTypeChange(changeType, this.getTypeId(), this.getSourceType().getTypeId(), list);
    }
}

