/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.JobAutomaton;
import oracle.dbtools.raptor.metrics.engine.JobAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.RunnableInstance;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.JobChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class JobInstance
extends RunnableInstance {
    private final JobAutomaton automaton = new JobAutomaton(this);
    private ExecutionService executionService;
    private final Map<Map<String, String>, JobPartition> jobPartitionMap = new HashMap<Map<String, String>, JobPartition>();
    private InstanceProperty<Double> minimumIntervalProperty;
    private InstanceProperty<Boolean> disabledProperty;

    protected JobInstance(JobType jobType, SourceInstance sourceInstance) {
        super(jobType, sourceInstance, null);
    }

    @Override
    public abstract JobType getRunnableType();

    Collection<JobPartition> getPartitions() {
        return this.jobPartitionMap.values();
    }

    JobPartition getPartition(Map<String, String> map) {
        JobPartition jobPartition = this.jobPartitionMap.get(map);
        if (jobPartition == null && (jobPartition = this.getRunnableType().newPartition(this, map)) != null) {
            this.jobPartitionMap.put(map, jobPartition);
            this.executionService.addEvent(this.automaton.createRequestRun());
        }
        return jobPartition;
    }

    JobAutomaton getAutomaton() {
        return this.automaton;
    }

    void removePartition(Map<String, String> map) {
        this.jobPartitionMap.remove(map);
        if (this.jobPartitionMap.isEmpty() && !((JobAutomatonActions)this.getAutomaton().getState()).isRunning()) {
            this.executionService.addEvent(this.getAutomaton().createRemove());
        }
    }

    @Override
    void start(Context context, List<InstanceProperty<?>> list) {
        super.start(context, list);
        if (this.getRunnableType().getMinimumInterval() != null) {
            this.minimumIntervalProperty = this.findProperty("minimumInterval", list);
        }
        this.disabledProperty = this.findProperty("disabled", list);
        this.executionService = context.getExecutionService();
        if (this.minimumIntervalProperty != null) {
            this.minimumIntervalProperty.getObservable().addListener((observableValue, d, d2) -> {
                if (d < 0.0 && d2 >= 0.0) {
                    this.executionService.addEvent(this.getAutomaton().createRequestRun());
                } else if (d >= 0.0 && d2 < 0.0) {
                    this.executionService.addEvent(this.getAutomaton().createCancelTimer());
                }
            });
        }
        this.disabledProperty.getObservable().addListener((observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.executionService.addEvent(this.getAutomaton().createDisable());
            } else {
                this.executionService.addEvent(this.getAutomaton().createEnable());
            }
        });
        this.getAutomaton().start();
    }

    InstanceProperty<Double> getMinimumInterval() {
        return this.minimumIntervalProperty;
    }

    InstanceProperty<Boolean> getDisabled() {
        return this.disabledProperty;
    }

    protected abstract DataMap load(Map<String, Object> var1);

    boolean isDisabled() {
        JobAutomatonActions jobAutomatonActions = (JobAutomatonActions)this.getAutomaton().getState();
        return jobAutomatonActions != null ? jobAutomatonActions.isDisabled() : true;
    }

    boolean isPinned() {
        JobAutomatonActions jobAutomatonActions = (JobAutomatonActions)this.getAutomaton().getState();
        return jobAutomatonActions != null ? jobAutomatonActions.isPinned() : true;
    }

    @Override
    void remove() {
        super.remove();
        this.getSource().removeJob(this.getPath());
        this.getContext().getActivityListenerService().addEngineObjectChange(this, ChangeType.REMOVE);
    }

    @Override
    protected JobChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new JobChange(changeType, this.getId(), this.getRunnableType().getTypeId(), this.getSource().getId(), this.isRunning(), this.getLastRunElapsedTime(), this.getLastRunCPUTime(), this.getLastRunException(), list);
    }
}

