/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.AbstractInstanceObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.listener.ChangeType;

public abstract class ContainerInstanceObject
extends AbstractInstanceObject {
    private Context context;
    private List<InstanceProperty<?>> properties;

    protected ContainerInstanceObject(URI uRI) {
        super(uRI);
    }

    public List<InstanceProperty<?>> getProperties() {
        return this.properties;
    }

    public <T> InstanceProperty<T> getProperty(Class<T> clazz, String string) {
        InstanceProperty<T> instanceProperty = this.findProperty(string, this.getProperties());
        if (instanceProperty != null && !clazz.isAssignableFrom(instanceProperty.getMeta().getType())) {
            return null;
        }
        return instanceProperty;
    }

    @Override
    protected Logger getLogger() {
        return this.context.getLogger();
    }

    Context getContext() {
        return this.context;
    }

    <T> InstanceProperty<T> findProperty(String string, List<InstanceProperty<?>> list) {
        return this.getProperties().stream().filter(instanceProperty -> instanceProperty.getMeta().getName().equals(string)).findFirst().orElse(null);
    }

    void start(Context context, List<InstanceProperty<?>> list) {
        this.context = context;
        this.properties = list;
        context.getActivityListenerService().addEngineObjectChange(this, ChangeType.ADD);
    }
}

