/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import oracle.dbtools.raptor.metrics.engine.AutomatonActions;
import oracle.dbtools.raptor.metrics.engine.ContainerInstanceObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.InputEventResponder;
import oracle.dbtools.raptor.metrics.engine.TracingService;

abstract class Automaton<A extends AutomatonActions<A>> {
    private A state;

    Automaton() {
    }

    void start() {
        this.state = this.getInitialState();
    }

    abstract A getInitialState();

    A getState() {
        return this.state;
    }

    abstract ContainerInstanceObject getFocusObject();

    Context getContext() {
        return this.getFocusObject().getContext();
    }

    String getCurrentStateName() {
        return this.state != null ? ((AutomatonActions)this.state).getName() : "REMOVED";
    }

    InputEvent createRemove() {
        return new AutomatonInputEvent(){

            @Override
            A callResponse(A a) {
                return ((AutomatonActions)a).remove();
            }

            @Override
            String getName() {
                return "remove";
            }
        };
    }

    void dispatchEvent(InputEventResponder<A> inputEventResponder) {
        if (this.state != null) {
            String string = this.getCurrentStateName();
            this.state = inputEventResponder.callResponse(this.state);
            TracingService tracingService = this.getContext().getTracingService();
            if (tracingService.isTracingEnabled()) {
                tracingService.traceEvent(this.getFocusObject().getId(), inputEventResponder.getName(), string, this.getCurrentStateName());
            }
        }
    }

    abstract class AutomatonInputEvent
    extends InputEventResponder<A> {
        AutomatonInputEvent() {
        }

        @Override
        void dispatch() {
            Automaton.this.dispatchEvent(this);
        }
    }
}

