/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Rectangle2D;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AbstractTreeControl;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.Tree;
import oracle.dbtools.raptor.metrics.control.TreeEdge;
import oracle.dbtools.raptor.metrics.control.TreeLayout;
import oracle.dbtools.raptor.metrics.control.TreeVertex;

public class TreeControl<T>
extends AbstractTreeControl<T, Tree<T, TreeVertex<T>, TreeEdge<T>>, TreeVertex<T>, TreeEdge<T>> {
    private static final double VERTEX_LABEL_GAP = 5.0;

    public TreeControl() {
        super(new TreeLayout(new Tree()));
    }

    @Override
    protected Rectangle2D computeBounds(double d, double d2) {
        double d3;
        double d4;
        double d5;
        Object object;
        Object object2;
        double d6 = 0.0;
        double d7 = 0.0;
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            object2 = uIVertex.getRepresentation();
            object = uIVertex.getDisplay();
            d5 = ((AreaComponent)object2).getWidth();
            d4 = ((AreaComponent)object2).getHeight();
            if (object != null && (d3 = ((AreaComponent)object).getHeight()) > d4) {
                d4 = d3;
            }
            if (d5 > d6) {
                d6 = d5;
            }
            if (!(d4 > d7)) continue;
            d7 = d4;
        }
        double d8 = this.getMaxDisplayWidth();
        object2 = (TreeVertex)((Tree)this.getGraph()).getRoot();
        if (object2 != null) {
            object = this.getUIVertex(object2);
            d5 = ((AbstractGraphControl.UIVertex)object).getRepresentation().getWidth();
            d4 = ((AbstractGraphControl.UIVertex)object).getDisplay().getWidth();
            d3 = d4 + 0.5 * d5 + 5.0;
            double d9 = 0.5 * d7;
            double d10 = Math.max(d - d4 - d5 - d8 - 10.0, 0.0);
            double d11 = Math.max(d2 - d7, 0.0);
            return new Rectangle2D(d3, d9, d10, d11);
        }
        return new Rectangle2D(0.0, 0.0, 1.0, 1.0);
    }

    @Override
    protected AbstractTreeControl.BezierControlPoints computeBezierControlPoints(AbstractGraphControl.UIEdge uIEdge) {
        TreeEdge treeEdge = (TreeEdge)uIEdge.getEdge();
        double d = this.getPhysicalX(((TreeVertex)treeEdge.getSource()).getX());
        double d2 = this.getPhysicalY(((TreeVertex)treeEdge.getSource()).getY());
        double d3 = this.getPhysicalX(((TreeVertex)treeEdge.getDest()).getX());
        double d4 = this.getPhysicalY(((TreeVertex)treeEdge.getDest()).getY());
        return new AbstractTreeControl.BezierControlPoints((d + d3) / 2.0, d2, (d + d3) / 2.0, d4);
    }

    @Override
    protected AbstractTreeControl.VertexDisplayGeometry computeVertexDisplayGeometry(AbstractGraphControl.UIVertex uIVertex) {
        TreeVertex treeVertex = (TreeVertex)uIVertex.getVertex();
        double d = uIVertex.getRepresentation().getCenterX();
        double d2 = uIVertex.getRepresentation().getWidth();
        double d3 = uIVertex.getDisplay().getWidth();
        double d4 = 5.0 + 0.5 * d2 + 0.5 * d3;
        d = treeVertex.isLeaf() ? (d += d4) : (d -= d4);
        double d5 = uIVertex.getRepresentation().getCenterY();
        return new AbstractTreeControl.VertexDisplayGeometry(0.0, d, d5);
    }

    @Override
    protected double computePrefHeight() {
        double d;
        TreeVertex treeVertex = (TreeVertex)((Tree)this.getGraph()).getRoot();
        if (treeVertex != null) {
            int n;
            int n2 = ((Tree)this.getGraph()).getMaxVertexLevel() + 1;
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new ArrayList());
            }
            for (AbstractGraphControl.UIVertex object : this.getUIVertices()) {
                if (object.getStatus() == AbstractGraphControl.UIStatus.REMOVED) continue;
                ((List)arrayList.get(((TreeVertex)object.getVertex()).getLevel())).add(object);
            }
            for (n = 0; n < n2; ++n) {
                arrayList.set(n, this.sortVerticesByY((Collection)arrayList.get(n)));
            }
            d = 0.0;
            for (n = 0; n < n2; ++n) {
                double d2;
                double d3;
                List list = (List)arrayList.get(n);
                int n3 = list.size();
                if (n3 > 1) {
                    d3 = ((AbstractGraphControl.UIVertex)list.get(0)).getRepresentation().getHeight();
                    d2 = ((AbstractGraphControl.UIVertex)list.get(n3 - 1)).getRepresentation().getHeight();
                    double d4 = d3 + d2;
                    for (int i = 1; i < n3; ++i) {
                        double d5;
                        double d6;
                        AbstractGraphControl.UIVertex uIVertex = (AbstractGraphControl.UIVertex)list.get(i - 1);
                        AbstractGraphControl.UIVertex uIVertex2 = (AbstractGraphControl.UIVertex)list.get(i);
                        TreeVertex treeVertex2 = (TreeVertex)uIVertex.getVertex();
                        TreeVertex treeVertex3 = (TreeVertex)uIVertex2.getVertex();
                        double d7 = treeVertex3.getY() - treeVertex2.getY();
                        double d8 = uIVertex.getRepresentation().getHeight();
                        AreaComponent areaComponent = uIVertex.getDisplay();
                        if (areaComponent != null && (d6 = areaComponent.getHeight()) > d8) {
                            d8 = d6;
                        }
                        d6 = uIVertex2.getRepresentation().getHeight();
                        AreaComponent areaComponent2 = uIVertex2.getDisplay();
                        if (areaComponent2 != null && (d5 = areaComponent2.getHeight()) > d6) {
                            d6 = d5;
                        }
                        if (!((d5 = 0.6 * (d8 + d6) / d7 + d4) > d)) continue;
                        d = d5;
                    }
                    continue;
                }
                if (n3 != 1) continue;
                d3 = 1.2 * ((AbstractGraphControl.UIVertex)list.get(0)).getRepresentation().getHeight();
                if (d3 > d) {
                    d = d3;
                }
                if (!((d2 = ((AbstractGraphControl.UIVertex)list.get(0)).getDisplay().getHeight()) > d)) continue;
                d = d2;
            }
        } else {
            d = 1.0;
        }
        return d;
    }

    @Override
    protected double computePrefWidth() {
        double d;
        TreeVertex treeVertex = (TreeVertex)((Tree)this.getGraph()).getRoot();
        if (treeVertex != null) {
            AbstractGraphControl.UIVertex uIVertex = this.getUIVertex((TreeVertex)((Tree)this.getGraph()).getRoot());
            double d2 = uIVertex.getRepresentation().getWidth();
            double d3 = uIVertex.getDisplay().getWidth();
            int n = ((Tree)this.getGraph()).getMaxVertexLevel();
            d = d3 + (double)n * 2.0 * (this.getMaxDisplayWidth() + d2) + d3;
        } else {
            d = 1.0;
        }
        return d;
    }

    private List<AbstractGraphControl.UIVertex> sortVerticesByY(Collection<AbstractGraphControl.UIVertex> collection) {
        ArrayList<AbstractGraphControl.UIVertex> arrayList = new ArrayList<AbstractGraphControl.UIVertex>(collection);
        Collections.sort(arrayList, (uIVertex, uIVertex2) -> {
            double d;
            TreeVertex treeVertex = (TreeVertex)uIVertex.getVertex();
            TreeVertex treeVertex2 = (TreeVertex)uIVertex2.getVertex();
            double d2 = treeVertex.getY();
            if (d2 == (d = treeVertex2.getY())) {
                return treeVertex.getId() > treeVertex2.getId() ? -1 : 1;
            }
            return d2 < d ? -1 : 1;
        });
        return arrayList;
    }
}

