/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.metrics.control.Edge;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.Vertex;

public class Tree<T, V extends Vertex<T, V, E>, E extends Edge<T, V, E>>
extends Graph<T, V, E> {
    private V root;

    public V getRoot() {
        this.verifyGlobal();
        return this.root;
    }

    @Override
    protected boolean beforeAddEdge(E e) {
        if (!super.beforeAddEdge(e)) {
            return false;
        }
        Object v = ((Edge)e).getDest();
        return ((Vertex)v).getInDegree() <= 0;
    }

    @Override
    protected void afterRemoveEdge(E e) {
        Object v = ((Edge)e).getSource();
        Object v2 = ((Edge)e).getDest();
        ((Vertex)v).getDestToOutEdgeMap().remove(v2);
        ((Vertex)v2).getSourceToInEdgeMap().remove(v);
        ArrayList arrayList = new ArrayList(((Vertex)v2).getOutEdges());
        for (Edge edge : arrayList) {
            this.getEdges().remove((Object)edge);
        }
        Iterator iterator = this.getModifiableVertices();
        iterator.remove(v2);
        if (this.getEdges().isEmpty()) {
            iterator.remove(((Edge)e).getSource());
        }
        this.notifyChanges();
    }

    @Override
    protected void calculateGlobal() {
        super.calculateGlobal();
        this.root = null;
        for (Vertex vertex : this.getVertices()) {
            if (vertex.getInDegree() != 0) continue;
            this.root = vertex;
            break;
        }
    }
}

