/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.geometry.Rectangle2D;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AbstractTreeControl;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.RadialTreeLayout;
import oracle.dbtools.raptor.metrics.control.Tree;
import oracle.dbtools.raptor.metrics.control.TreeEdge;
import oracle.dbtools.raptor.metrics.control.TreeVertex;

public class RadialTreeControl<T>
extends AbstractTreeControl<T, Tree<T, TreeVertex<T>, TreeEdge<T>>, TreeVertex<T>, TreeEdge<T>> {
    private static final double VERTEX_LABEL_GAP = 5.0;

    public RadialTreeControl() {
        super(new RadialTreeLayout(new Tree()));
    }

    @Override
    protected Rectangle2D computeBounds(double d, double d2) {
        double d3 = 0.0;
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            AreaComponent areaComponent = uIVertex.getRepresentation();
            double d4 = areaComponent.getWidth();
            double d5 = areaComponent.getHeight();
            if (d4 > d3) {
                d3 = d4;
            }
            if (!(d5 > d3)) continue;
            d3 = d5;
        }
        double d6 = Math.min(d, d2);
        double d7 = this.getMaxDisplayWidth();
        double d8 = d7 + d3;
        double d9 = d6 - 2.0 * d3 - 2.0 * d7;
        return new Rectangle2D(d8, d8, d9, d9);
    }

    @Override
    protected AbstractTreeControl.BezierControlPoints computeBezierControlPoints(AbstractGraphControl.UIEdge uIEdge) {
        double d;
        double d2;
        double d3;
        double d4;
        TreeEdge treeEdge = (TreeEdge)uIEdge.getEdge();
        double d5 = ((TreeVertex)treeEdge.getSource()).getX();
        double d6 = ((TreeVertex)treeEdge.getSource()).getY();
        double d7 = ((TreeVertex)treeEdge.getDest()).getX();
        double d8 = ((TreeVertex)treeEdge.getDest()).getY();
        double d9 = Math.sqrt((d5 - 0.5) * (d5 - 0.5) + (d6 - 0.5) * (d6 - 0.5));
        double d10 = Math.sqrt((d7 - 0.5) * (d7 - 0.5) + (d8 - 0.5) * (d8 - 0.5));
        double d11 = 0.5 * (d9 + d10);
        if (d9 != 0.0) {
            d4 = 0.5 + (d5 - 0.5) * d11 / d9;
            d3 = 0.5 + (d6 - 0.5) * d11 / d9;
            d2 = 0.5 + (d7 - 0.5) * d11 / d10;
            d = 0.5 + (d8 - 0.5) * d11 / d10;
        } else {
            double d12 = 0.25 * Math.acos((d7 - d5) / d10);
            double d13 = d8 - d6 >= 0.0 ? 1.0 : -1.0;
            d4 = 0.5 + 0.5 * d10 * Math.cos(d12);
            d3 = 0.5 + 0.5 * d13 * d10 * Math.sin(d12);
            d2 = 0.5 + (d7 - 0.5) * d11 / d10;
            d = 0.5 + (d8 - 0.5) * d11 / d10;
        }
        return new AbstractTreeControl.BezierControlPoints(this.getPhysicalX(d4), this.getPhysicalY(d3), this.getPhysicalX(d2), this.getPhysicalY(d));
    }

    @Override
    protected AbstractTreeControl.VertexDisplayGeometry computeVertexDisplayGeometry(AbstractGraphControl.UIVertex uIVertex) {
        double d;
        double d2;
        double d3;
        TreeVertex treeVertex = (TreeVertex)uIVertex.getVertex();
        double d4 = treeVertex.getX() - 0.5;
        double d5 = treeVertex.getY() - 0.5;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = uIVertex.getDisplay().getWidth();
        double d8 = 10.0 + Math.max(uIVertex.getRepresentation().getWidth(), uIVertex.getRepresentation().getHeight());
        if (d4 == 0.0 && d5 == 0.0) {
            d3 = 0.0;
            d2 = this.getPhysicalX(treeVertex.getX()) - 0.5 * (d7 + d8);
            d = this.getPhysicalY(treeVertex.getY());
        } else if (d4 >= 0.0) {
            d3 = Math.atan2(d5, d4);
            d2 = this.getPhysicalX(treeVertex.getX()) + d4 / d6 * 0.5 * (d8 + d7);
            d = this.getPhysicalY(treeVertex.getY()) + d5 / d6 * 0.5 * (d8 + d7);
        } else {
            d3 = Math.PI + Math.atan2(d5, d4);
            d2 = this.getPhysicalX(treeVertex.getX()) + d4 / d6 * 0.5 * (d8 + d7);
            d = this.getPhysicalY(treeVertex.getY()) + d5 / d6 * 0.5 * (d8 + d7);
        }
        return new AbstractTreeControl.VertexDisplayGeometry(d3, d2, d);
    }

    @Override
    protected double computePrefHeight() {
        double d = this.getMaxDisplayWidth();
        int n = ((Tree)this.getGraph()).getMaxVertexLevel();
        return 3.0 * d * (double)n;
    }

    @Override
    protected double computePrefWidth() {
        return this.computePrefHeight();
    }
}

