/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;
import oracle.dbtools.raptor.metrics.listener.EngineObjectChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class ViewObject<A extends EngineObjectChange> {
    private final List<ViewPropertyImpl<?>> properties = new ArrayList();
    private final ObjectProperty<URI> idProperty = new SimpleObjectProperty((Object)this, "id");
    private final StringBinding pathProperty = Bindings.createStringBinding(() -> DXIds.getPath((URI)this.idProperty.get()), (Observable[])new Observable[]{this.idProperty});

    public List<? extends ViewProperty<?>> getProperties() {
        return this.properties;
    }

    public String toString() {
        return DXIds.getPath((URI)this.idProperty.get());
    }

    public URI getId() {
        return (URI)this.idProperty.get();
    }

    public ObservableObjectValue<URI> idProperty() {
        return this.idProperty;
    }

    public String getPath() {
        return this.pathProperty.get();
    }

    public ObservableStringValue pathProperty() {
        return this.pathProperty;
    }

    ViewObject() {
    }

    void onAdd(Context context, A a) {
        this.idProperty.set((Object)((EngineObjectChange)a).getFocusId());
        for (PropertyValue<?> propertyValue : ((EngineObjectChange)a).getPropertyValues()) {
            this.properties.add(new ViewPropertyImpl(propertyValue));
        }
    }

    void onUpdate(A a) {
        List<PropertyValue<?>> list = ((EngineObjectChange)a).getPropertyValues();
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyValue<?> propertyValue = list.get(i);
            this.properties.get(i).updateFrom(propertyValue);
        }
    }

    void onRemove() {
    }

    class ViewPropertyImpl<T>
    implements ViewProperty<T> {
        private final MetaProperty<T> meta;
        private final ObjectProperty<T> valueProperty;
        private final StringBinding asStringBinding;
        private final BooleanProperty overriddenProperty;

        ViewPropertyImpl(PropertyValue<T> propertyValue) {
            this.meta = propertyValue.getMeta();
            this.overriddenProperty = new SimpleBooleanProperty(propertyValue.isOverridden());
            this.valueProperty = new SimpleObjectProperty(propertyValue.getValue());
            this.asStringBinding = Bindings.createStringBinding(() -> this.meta.toString(this.valueProperty.get()), (Observable[])new Observable[]{this.valueProperty});
        }

        @Override
        public MetaProperty<T> getMeta() {
            return this.meta;
        }

        @Override
        public T get() {
            return (T)this.valueProperty.get();
        }

        @Override
        public ObservableObjectValue<T> getObservable() {
            return this.valueProperty;
        }

        @Override
        public ObservableStringValue asString() {
            return this.asStringBinding;
        }

        @Override
        public boolean isOverridden() {
            return this.overriddenProperty.get();
        }

        @Override
        public ObservableBooleanValue overriddenProperty() {
            return this.overriddenProperty;
        }

        void updateFrom(PropertyValue<T> propertyValue) {
            this.valueProperty.set(propertyValue.getValue());
            this.overriddenProperty.set(propertyValue.isOverridden());
        }
    }

    static abstract class Context {
        Context() {
        }

        abstract <V extends ViewObject<? extends EngineObjectChange>> V lookupObject(Class<V> var1, URI var2);
    }
}

