/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.JobElement;
import oracle.dbtools.raptor.metrics.console.JobView;
import oracle.dbtools.raptor.metrics.console.MetaAttribute;
import oracle.dbtools.raptor.metrics.console.Operations;
import oracle.dbtools.raptor.metrics.console.SourceView;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;

class SourceElement
extends Element<JobView> {
    private final SourceView sourceView;
    private static final List<MetaAttribute> ATTRIBUTE_LABELS = new ArrayList<MetaAttribute>();
    private static final List<MetaAttribute> CHILD_ATTRIBUTE_LABELS = new ArrayList<MetaAttribute>();

    SourceElement(SourceView sourceView) {
        super(sourceView.toString(), sourceView.getJobs());
        this.sourceView = sourceView;
    }

    @Override
    URI getId() {
        return this.sourceView.getId();
    }

    @Override
    String getPath() {
        return this.sourceView.getPath();
    }

    @Override
    List<MetaAttribute> getMetaAttributes() {
        return ATTRIBUTE_LABELS;
    }

    @Override
    List<MetaAttribute> getChildMetaAttributes() {
        return CHILD_ATTRIBUTE_LABELS;
    }

    @Override
    List<? extends ViewProperty<?>> getProperties() {
        return this.sourceView.getProperties();
    }

    @Override
    List<? extends ViewProperty<?>> getDefaultProperties() {
        return this.sourceView.getSourceType().getProperties();
    }

    @Override
    String getIconPath() {
        return "oracle/dbtools/raptor/images/db.png";
    }

    @Override
    Element<?> createChildElement(JobView jobView) {
        return new JobElement(jobView);
    }

    @Override
    List<ObservableStringValue> createAttributeValues() {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.add(this.sourceView.connectionDisplayNameProperty());
        observableList.add(Bindings.createStringBinding(() -> this.getId().toString(), (Observable[])new Observable[]{this.sourceView.idProperty()}));
        ObservableBooleanValue observableBooleanValue = this.sourceView.connectedProperty();
        observableList.add(Bindings.createStringBinding(() -> Boolean.toString(observableBooleanValue.get()), (Observable[])new Observable[]{observableBooleanValue}));
        List<ViewProperty<?>> list = this.sourceView.getProperties();
        observableList.add(list.stream().filter(viewProperty -> viewProperty.getMeta().getName().equals("minimumInterval")).findFirst().get().asString());
        observableList.add(list.stream().filter(viewProperty -> viewProperty.getMeta().getName().equals("connectionCount")).findFirst().get().asString());
        return observableList;
    }

    @Override
    List<ObservableStringValue> createChildAttributeValues(JobView jobView) {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.add(jobView.pathProperty());
        ObservableBooleanValue observableBooleanValue = jobView.disabledProperty();
        observableList.add(Bindings.createStringBinding(() -> Boolean.toString(observableBooleanValue.get()), (Observable[])new Observable[]{observableBooleanValue}));
        List<ViewProperty<?>> list = jobView.getProperties();
        Optional<ViewProperty> optional = list.stream().filter(viewProperty -> viewProperty.getMeta().getName().equals("minimumInterval")).findFirst();
        if (optional.isPresent()) {
            observableList.add(optional.get().asString());
        } else {
            observableList.add(null);
        }
        ObservableDoubleValue observableDoubleValue = jobView.lastElapsedTimeProperty();
        observableList.add(Bindings.createStringBinding(() -> Double.toString(observableDoubleValue.get()), (Observable[])new Observable[]{observableDoubleValue}));
        observableList.add(jobView.lastStatusProperty());
        return observableList;
    }

    @Override
    <T> void addUseDefaultPropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_SOURCE_RESET", this.sourceView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_SOURCE_NOT_CHANGED", this.sourceView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.useDefaultProperty(this.sourceView.getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), dXOperationCallback));
    }

    @Override
    <T> void addSetPropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_SOURCE_UPDATED", this.sourceView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_SOURCE_NOT_CHANGED", this.sourceView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.setProperty(this.sourceView.getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), t, dXOperationCallback));
    }

    @Override
    <T> void addUseDefaultTypePropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_SOURCE_TYPE_RESET", this.sourceView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_SOURCE_TYPE_NOT_CHANGED", this.sourceView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.useDefaultProperty(this.sourceView.getSourceType().getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), dXOperationCallback));
    }

    @Override
    <T> void addSetTypePropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_SOURCE_TYPE_UPDATED", this.sourceView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_SOURCE_TYPE_NOT_CHANGED", this.sourceView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.setProperty(this.sourceView.getSourceType().getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), t, dXOperationCallback));
    }

    static {
        Collections.addAll(ATTRIBUTE_LABELS, new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_CONNECTION_NAME"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_SOURCE_ID"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_CONNECTED"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_CONNECT_INTERVAL"), HPos.RIGHT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_POOL_SIZE"), HPos.RIGHT));
        Collections.addAll(CHILD_ATTRIBUTE_LABELS, new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_JOB_PATH"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_DISABLED"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_INTERVAL"), HPos.RIGHT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_ELAPSED_TIME"), HPos.RIGHT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_STATUS"), HPos.LEFT));
    }
}

