/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import javafx.beans.property.Property;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.console.ViewPropertyEditor;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;

class NumericElementPropertyEditor
extends ViewPropertyEditor<Number> {
    private final Spinner<Number> control;
    private final Spinner<Number> defaultControl;
    private final Property<Number> valueProperty;
    private final Property<Number> defaultValueProperty;

    NumericElementPropertyEditor(Element<?> element, ViewProperty<Number> viewProperty, ViewProperty<Number> viewProperty2) {
        super(element, viewProperty, viewProperty2);
        this.defaultControl = this.createNumericEditor(viewProperty2);
        this.control = this.createNumericEditor(viewProperty);
        this.valueProperty = this.control.getValueFactory().valueProperty();
        this.defaultValueProperty = this.defaultControl.getValueFactory().valueProperty();
    }

    Spinner<Number> getControl() {
        return this.control;
    }

    Spinner<Number> getDefaultControl() {
        return this.defaultControl;
    }

    @Override
    Property<Number> getValueProperty() {
        return this.valueProperty;
    }

    @Override
    Property<Number> getDefaultValueProperty() {
        return this.defaultValueProperty;
    }

    private Spinner<Number> createNumericEditor(ViewProperty<Number> viewProperty) {
        final MetaProperty<Number> metaProperty = viewProperty.getMeta();
        SpinnerValueFactory<Number> spinnerValueFactory = new SpinnerValueFactory<Number>(){

            public void decrement(int n) {
                Number number = (Number)this.getValue();
                for (int i = 0; i < n; ++i) {
                    number = metaProperty.decrement(number);
                }
                try {
                    metaProperty.validate(number);
                    this.setValue(number);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public void increment(int n) {
                Number number = (Number)this.getValue();
                for (int i = 0; i < n; ++i) {
                    number = metaProperty.increment(number);
                }
                try {
                    metaProperty.validate(number);
                    this.setValue(number);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        spinnerValueFactory.setValue((Object)viewProperty.get());
        Spinner spinner = new Spinner((SpinnerValueFactory)spinnerValueFactory);
        spinner.setEditable(true);
        spinnerValueFactory.setConverter((StringConverter)new StringConverter<Number>((SpinnerValueFactory)spinnerValueFactory, spinner){
            final /* synthetic */ SpinnerValueFactory val$factory;
            final /* synthetic */ Spinner val$spinner;
            {
                this.val$factory = spinnerValueFactory;
                this.val$spinner = spinner;
            }

            public String toString(Number number) {
                return metaProperty.toString(number);
            }

            public Number fromString(String string) {
                Number number;
                try {
                    number = (Number)metaProperty.fromString(string);
                    metaProperty.validate(number);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    number = (Number)this.val$factory.getValue();
                    this.val$spinner.getEditor().setText(metaProperty.toString(number));
                }
                return number;
            }
        });
        return spinner;
    }
}

