/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.ItemView;
import oracle.dbtools.raptor.metrics.console.JobView;
import oracle.dbtools.raptor.metrics.console.MetaAttribute;
import oracle.dbtools.raptor.metrics.console.Operations;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;

class JobElement
extends Element<ItemView> {
    private final JobView jobView;
    private static final List<MetaAttribute> ATTRIBUTE_LABELS = new ArrayList<MetaAttribute>();
    private static final List<MetaAttribute> CHILD_ATTRIBUTE_LABELS = new ArrayList<MetaAttribute>();

    JobElement(JobView jobView) {
        super(jobView.toString(), jobView.getItems());
        this.jobView = jobView;
    }

    @Override
    URI getId() {
        return this.jobView.getId();
    }

    @Override
    String getPath() {
        return this.jobView.getPath();
    }

    @Override
    List<MetaAttribute> getMetaAttributes() {
        return ATTRIBUTE_LABELS;
    }

    @Override
    List<MetaAttribute> getChildMetaAttributes() {
        return CHILD_ATTRIBUTE_LABELS;
    }

    @Override
    List<? extends ViewProperty<?>> getProperties() {
        return this.jobView.getProperties();
    }

    @Override
    List<? extends ViewProperty<?>> getDefaultProperties() {
        return this.jobView.getJobType().getProperties();
    }

    @Override
    String getIconPath() {
        return "oracle/dbtools/raptor/images/job.png";
    }

    @Override
    boolean maintainChildTreeItems() {
        return false;
    }

    @Override
    List<ObservableStringValue> createAttributeValues() {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.add(this.jobView.pathProperty());
        ObservableBooleanValue observableBooleanValue = this.jobView.disabledProperty();
        observableList.add(Bindings.createStringBinding(() -> Boolean.toString(observableBooleanValue.get()), (Observable[])new Observable[]{observableBooleanValue}));
        List<ViewProperty<?>> list = this.jobView.getProperties();
        Optional<ViewProperty> optional = list.stream().filter(viewProperty -> viewProperty.getMeta().getName().equals("minimumInterval")).findFirst();
        if (optional.isPresent()) {
            observableList.add(optional.get().asString());
        } else {
            observableList.add(null);
        }
        ObservableDoubleValue observableDoubleValue = this.jobView.lastElapsedTimeProperty();
        observableList.add(Bindings.createStringBinding(() -> Double.toString(observableDoubleValue.get()), (Observable[])new Observable[]{observableDoubleValue}));
        observableList.add(this.jobView.lastStatusProperty());
        return observableList;
    }

    @Override
    List<ObservableStringValue> createChildAttributeValues(ItemView itemView) {
        ObservableList observableList = FXCollections.observableArrayList();
        Callable<String> callable = () -> {
            String string = itemView.getPath();
            String string2 = itemView.getParameters();
            if (string2 != null && !string2.isEmpty()) {
                return string + "?" + string2;
            }
            return string;
        };
        observableList.add(Bindings.createStringBinding(callable, (Observable[])new Observable[]{itemView.pathProperty(), itemView.parametersProperty()}));
        observableList.add(itemView.getItemType().changeClassNameProperty());
        return observableList;
    }

    @Override
    <T> void addUseDefaultPropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_JOB_RESET", this.jobView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_JOB_NOT_CHANGED", this.jobView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.useDefaultProperty(this.jobView.getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), dXOperationCallback));
    }

    @Override
    <T> void addSetPropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_JOB_UPDATED", this.jobView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_JOB_NOT_CHANGED", this.jobView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.setProperty(this.jobView.getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), t, dXOperationCallback));
    }

    @Override
    <T> void addUseDefaultTypePropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_JOB_TYPE_RESET", this.jobView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_JOB_TYPE_NOT_CHANGED", this.jobView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.useDefaultProperty(this.jobView.getJobType().getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), dXOperationCallback));
    }

    @Override
    <T> void addSetTypePropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        MetaProperty<T> metaProperty = viewProperty.getMeta();
        operations.addCall(MetricsResources.format("METRICS_CONSOLE_JOB_TYPE_UPDATED", this.jobView.getId(), metaProperty.getLabel()), MetricsResources.format("METRICS_CONSOLE_JOB_TYPE_NOT_CHANGED", this.jobView.getId(), metaProperty.getLabel()), dXOperationCallback -> DXService.setProperty(this.jobView.getJobType().getId(), viewProperty.getMeta().getType(), viewProperty.getMeta().getName(), t, dXOperationCallback));
    }

    static {
        Collections.addAll(ATTRIBUTE_LABELS, new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_JOB_PATH"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_DISABLED"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_INTERVAL"), HPos.RIGHT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_ELAPSED_TIME"), HPos.RIGHT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_RUN_STATUS"), HPos.LEFT));
        Collections.addAll(CHILD_ATTRIBUTE_LABELS, new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_ITEM_PATH"), HPos.LEFT), new MetaAttribute(MetricsResources.get("METRICS_CONSOLE_CHANGE_CLASS"), HPos.LEFT));
    }
}

