/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.actionobject.AbstractFileSelectionAction;
import oracle.dbtools.raptor.metrics.actionobject.BackgroundTask;

public class SaveSnapshot
extends AbstractFileSelectionAction {
    public SaveSnapshot() {
        this.init(new Listener());
    }

    @Override
    public Boolean get() {
        Scene scene = this.getScene();
        WritableImage writableImage = new WritableImage((int)scene.getWidth(), (int)scene.getHeight());
        scene.snapshot(writableImage);
        String[] stringArray = ImageIO.getWriterFormatNames();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        String string = MetricsResources.getString("METRICS_SAVE_IMAGE_TITLE");
        String string2 = MetricsResources.getString("METRICS_IMAGE_FILES_FILTER_NAME");
        final File file = this.selectFile(string, string2, hashSet, Arrays.asList("png", "jpg", "gif"));
        if (file != null) {
            String string3 = file.getName();
            int n = string3.lastIndexOf(".");
            final String string4 = n < 0 || n >= string3.length() - 1 ? "png" : string3.substring(n + 1);
            final BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
            BackgroundTask backgroundTask = new BackgroundTask(){

                @Override
                protected void doTask(BackgroundTask.Context context) {
                    SaveSnapshot.this.writeImageFile(context, bufferedImage, file, string4);
                }
            };
            backgroundTask.enqueue();
        }
        return true;
    }

    private void writeImageFile(BackgroundTask.Context context, RenderedImage renderedImage, File file, String string) {
        try {
            boolean bl = ImageIO.write(renderedImage, string, file);
            if (bl) {
                context.setStatus(true, MetricsResources.format("METRICS_SNAPSHOT_SUCCESS", file.getAbsolutePath()));
            } else {
                context.setStatus(false, MetricsResources.format("METRICS_SNAPSHOT_FORMAT_NOT_SUPPORTED", file.getAbsolutePath()));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, iOException);
            context.setStatus(false, MetricsResources.format("METRICS_SNAPSHOT_FAILURE", file.getAbsolutePath(), iOException.getLocalizedMessage()));
        }
    }

    protected class Listener
    extends AbstractFileSelectionAction.Listener {
        protected Listener() {
        }
    }
}

