/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.offline;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.core.util.RaptorGroupLoader;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.offline.streams.MdColumnComparator;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.teradata.offline.AbstractTeradataOfflineStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.preferences.MaskUtil;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class OfflineFEXPSQLLoaderTeradataDMStream
extends AbstractTeradataOfflineStream {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getName());
    protected StringTemplateGroup m_templateGroup = null;
    private static final String FILENAME = "fexp";
    private static final String CONTROL_NAME = "control";
    private static final String EXTENSION = "fexp.ctl";
    private static final String TYPE = "loader";
    private PrintWriter fePW;

    public OfflineFEXPSQLLoaderTeradataDMStream(String string, MigrationPlugin migrationPlugin) {
        super(string, TYPE);
        this.setPlugin(migrationPlugin);
    }

    public String getExtension() {
        return EXTENSION;
    }

    public String getFileName() {
        return FILENAME;
    }

    public String getGenType() {
        return TYPE;
    }

    public String getDataFileName(String string, String string2) {
        return this.getPlugin().createDataFileName(string, string2);
    }

    public String getRowDelimiter() {
        return null;
    }

    public String getFieldTerminator() {
        return null;
    }

    public ArrayList<String> getColumnList() {
        return null;
    }

    public void println(PrintWriter printWriter, String string, boolean bl) {
        try {
            printWriter.print(bl ? OfflineDMSAbstract.makeWindows((CharSequence)string) : OfflineDMSAbstract.makeUnix((CharSequence)string));
            printWriter.print(bl ? "\r\n" : "\n");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void finished() {
    }

    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        try {
            this.setPlugin(MigrationUtils.getPluginForConnection((MdConnection)mdConnection));
        }
        catch (MigrationPluginException migrationPluginException) {
            this.LOGGER.log(Level.SEVERE, "Migration Plugin cannot be found");
        }
        this.mdConnection = mdConnection;
        this.m_persistenceManager = persistenceManager;
    }

    public void startDatabase(String string, String string2) {
        this.setCatalogDir("Teradata");
    }

    public void endDatabase() {
    }

    public void startSchema(String string, String string2) {
        this.setCatalogDir("Teradata");
        this.schemaDir = string2;
    }

    public void endSchema() {
        if (this.fePW != null) {
            this.fePW.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTable(String string) {
        String string2 = this.getSchemaDir() + File.separator + this.getDir();
        OfflineFEXPSQLLoaderTeradataDMStream.setWriteDir(string2);
        String string3 = string + "." + this.getExtension();
        String string4 = string2 + File.separator + string3;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new File(string4));
            this.println(printWriter, this.getTableCommand(this.m_descriptor, this.getExtension(), string, this.m_plugin), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    public String getTableCommand(DataMoveDescriptor dataMoveDescriptor, String string, String string2, MigrationPlugin migrationPlugin) {
        StringTemplate stringTemplate = null;
        MdColumn[] mdColumnArray = dataMoveDescriptor.getTargetColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        this.loadTemplates();
        stringTemplate = this.m_templateGroup.getInstanceOf("FexpSQLLoaderStatement");
        stringTemplate.setAttribute("infile", (Object)OfflineFEXPSQLLoaderTeradataDMStream.createDataFileName(migrationPlugin, dataMoveDescriptor.getTargetTableName(true), dataMoveDescriptor.getSourceTableName()));
        stringTemplate.setAttribute("rowDelimiter", (Object)migrationPlugin.getDataMoveRowDelimiter());
        stringTemplate.setAttribute("table_name", (Object)string2);
        stringTemplate.setAttribute("fieldTerminator", (Object)migrationPlugin.getDataMoveColumnDelimiter());
        stringTemplate.setAttribute("colList", (Object)this.processColumns(dataMoveDescriptor, migrationPlugin));
        stringTemplate.setAttribute("column_definitions", Arrays.asList(mdColumnArray));
        stringTemplate.setAttribute("schemaName", (Object)dataMoveDescriptor.getTargetSchema().getName());
        return stringTemplate.toString();
    }

    static String createDataFileName(MigrationPlugin migrationPlugin, String string, String string2) {
        return migrationPlugin.createDataFileName(string + ".fexp", string2 + ".fexp");
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    protected String getDir() {
        return CONTROL_NAME;
    }

    private String[] processColumns(DataMoveDescriptor dataMoveDescriptor, MigrationPlugin migrationPlugin) {
        MdColumn[] mdColumnArray = dataMoveDescriptor.getSourceColumns();
        MdColumn[] mdColumnArray2 = dataMoveDescriptor.getTargetColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        Arrays.sort(mdColumnArray2, new MdColumnComparator());
        String[] stringArray = new String[mdColumnArray2.length];
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            stringArray[i] = this.formatCol(mdColumnArray[i], mdColumnArray2[i], migrationPlugin, i + 1 >= mdColumnArray2.length);
        }
        return stringArray;
    }

    private String formatCol(MdColumn mdColumn, MdColumn mdColumn2, MigrationPlugin migrationPlugin, boolean bl) {
        Object object = migrationPlugin.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
        String[] stringArray = MaskUtil.getMatchingRow((String)mdColumn.getColumnType());
        Object object2 = null;
        object2 = stringArray != null ? "\"" + stringArray[0] + "(:" + mdColumn2.getColumnName() + ", '" + stringArray[1] + "')\"" : this.getTeradataPlugin().getFEXPState().formatSQLLoaderColumn(this.getTeradataPlugin(), mdColumn, mdColumn2, bl);
        if (migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && mdColumn2.getColumnType().toUpperCase().equals("BLOB")) {
            object = "SQLDEVELOPER_CLOB_" + mdColumn2.getColumnOrder();
        }
        return (String)object + " " + (String)object2;
    }

    public void endTable() {
    }
}

