/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.dynamicconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.osgi.boot.OracleIdeLauncher;
import oracle.ide.osgi.boot.api.BundlesInfoUtil;
import oracle.ide.osgi.boot.api.ConfigurationAreaScanner;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import org.netbeans.core.dynamicconfig.BundleLocator;

public class RegisterJDevBundles
implements BundleLocator {
    private static final Logger LOG = Logger.getLogger(RegisterJDevBundles.class.getName());
    private static final Set<String> enabledModules = new HashSet<String>();
    private static final String DROPINS_SUPPORT_DIR = "dropins_support";
    private static final String EXCLUDED_MODULES = "excluded.modules";
    private final Set<String> excludedModules = new HashSet<String>();

    @Override
    public void search(BundleLocator.Response response) {
        String dropInDirs = IdeBootProperties.getBundleSearchPath();
        String bundlesInfoPath = IdeBootProperties.getSimpleConfiguratorPath();
        String excludedMods = System.getProperty(EXCLUDED_MODULES);
        if (bundlesInfoPath == null) {
            throw new IllegalStateException("Missing bundles.info path!");
        }
        if (excludedMods != null) {
            this.excludedModules.addAll(Arrays.asList(excludedMods.split(File.pathSeparator)));
        }
        for (String configurationAreaPath : ConfigurationAreaScanner.getScanner().getConfigurationAreas()) {
            if (configurationAreaPath == null) {
                throw new IllegalStateException("Missing osgi.configuration.area");
            }
            this.processJDevJars(configurationAreaPath, bundlesInfoPath, response);
            try {
                String configurationAreaPathOnly = new URL(configurationAreaPath).getPath();
                File configurationDirectory = new File(configurationAreaPathOnly);
                File[] otherBundleInfoFiles = configurationDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !"bundles.info".equals(name) && !"edt_bundles.info".equals(name) && !"cfu_bundles.info".equals(name) && name.endsWith("bundles.info");
                    }
                });
                if (otherBundleInfoFiles != null) {
                    for (File packageBundlesInfo : otherBundleInfoFiles) {
                        this.processJDevJars(configurationAreaPath, packageBundlesInfo.getName(), response);
                    }
                } else {
                    LOG.log(Level.SEVERE, "Can't list the files in the configuration directory. Could be caused by the fact that paths was not a directory, did not exist, or did not have read permissions.\n Does it exist? " + configurationDirectory.exists() + "\n Is it a  directory? " + configurationDirectory.isDirectory() + "\n Can it be read? " + configurationDirectory.canRead());
                }
            }
            catch (MalformedURLException e) {
                LOG.log(Level.SEVERE, "the path to the configuration directory " + configurationAreaPath + " is malformed", e);
            }
            this.processJDevJars(configurationAreaPath, "file:cfu_bundles.info", response);
            if (dropInDirs != null) {
                File systemDir = new File(IdeBootProperties.getSystemDirectory());
                File supportDir = new File(systemDir, DROPINS_SUPPORT_DIR);
                this.processDropIns(supportDir.getPath(), dropInDirs, response);
            }
            this.processJDevJars(configurationAreaPath, "file:edt_bundles.info", response);
        }
        String coreConfigurationComponents = System.getProperty("oracle.ide.core.configuration.components");
        if (coreConfigurationComponents != null) {
            String oracleHome = IdeBootProperties.getOracleHome();
            File configurationDirectory = new File(oracleHome, ".." + File.separator + "jdeveloper" + File.separator + "configuration");
            for (String coreConfigurationComponent : coreConfigurationComponents.split(",")) {
                if (coreConfigurationComponent == null) continue;
                String bundleInfoRelativeFilePath = "file:" + coreConfigurationComponent + ".bundles.info";
                this.processJDevJars(configurationDirectory.getAbsolutePath(), bundleInfoRelativeFilePath, response);
            }
        }
    }

    private void processJDevJars(String configurationAreaPath, String bundlesInfoPath, BundleLocator.Response response) {
        try {
            configurationAreaPath = new URL(configurationAreaPath).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            bundlesInfoPath = new URL(bundlesInfoPath).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        File bundlesInfo = new File(configurationAreaPath, bundlesInfoPath);
        if (!bundlesInfo.exists()) {
            return;
        }
        try {
            String configurationDirPath = IdeBootProperties.getProductHome() + File.separatorChar + "configuration";
            File configurationDir = new File(configurationDirPath);
            if (!configurationDir.exists()) {
                configurationDir.mkdir();
            }
            BufferedReader in = new BufferedReader(new FileReader(bundlesInfo));
            String line = in.readLine();
            while (line != null) {
                if (BundlesInfoUtil.isEntryValid((String)line)) {
                    int index = line.indexOf(",", 0);
                    String symbolicName = line.substring(0, index).trim();
                    int secondElementIndex = line.indexOf(",", index + 1);
                    String bundleJarFilePath = line.substring(secondElementIndex + 1, index = line.indexOf(",", secondElementIndex + 1)).trim();
                    File jarFile = new File(bundleJarFilePath);
                    if (jarFile.isAbsolute()) {
                        LOG.log(Level.FINE, "Registering {0} with absolute path {1}", new Object[]{symbolicName, bundleJarFilePath});
                        this.processBundleJar(jarFile.getPath(), symbolicName, response);
                    } else {
                        int nd = bundleJarFilePath.indexOf("../");
                        if (nd != -1) {
                            bundleJarFilePath = bundleJarFilePath.substring(nd + "../".length());
                        }
                        LOG.log(Level.FINEST, "Processing {0} as {1} . The relative path will be resolved relative to the Netbeans clusters (netbeans.dirs) .", new Object[]{symbolicName, bundleJarFilePath});
                        this.processBundleJar(bundleJarFilePath, symbolicName, response);
                    }
                } else {
                    LOG.log(Level.INFO, "Invalid entry in bundles.info file. Entry: \"{0}\"", line);
                }
                line = in.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException("Invalid path encountered while reading bundles.info! " + bundlesInfoPath.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processDropIns(String supportDir, String dropInDirs, BundleLocator.Response response) {
        String[] bundlesInfoPaths;
        for (String path : bundlesInfoPaths = this.getDropInBundlesInfoPaths(supportDir, dropInDirs)) {
            File bundlesInfo = new File(path);
            try {
                BufferedReader in = new BufferedReader(new FileReader(bundlesInfo));
                String line = in.readLine();
                while (line != null) {
                    if (BundlesInfoUtil.isEntryValid((String)line)) {
                        int index = line.indexOf(",", 0);
                        String symbolicName = line.substring(0, index).trim();
                        int secondElementIndex = line.indexOf(",", index + 1);
                        index = line.indexOf(",", secondElementIndex + 1);
                        String relativePath = line.substring(secondElementIndex + 1, index).trim();
                        this.processBundleJar(relativePath, symbolicName, response);
                    } else {
                        LOG.log(Level.WARNING, "Invalid entry in generated bundles.info file. File: \"{0}\". Entry: \"{1}\"", new Object[]{path, line});
                    }
                    line = in.readLine();
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception processing " + path, e);
            }
        }
    }

    private void processBundleJar(String relativePath, String symbolicName, BundleLocator.Response response) {
        if (!this.excludedModules.contains(symbolicName)) {
            LOG.log(Level.FINEST, "Registering {0} as {1}", new Object[]{symbolicName, relativePath});
            if (enabledModules.contains(symbolicName)) {
                response.enabled(symbolicName, relativePath);
            } else {
                response.autoload(symbolicName, relativePath);
            }
        } else {
            LOG.log(Level.FINEST, "Excluding {0} as {1}", new Object[]{symbolicName, relativePath});
        }
    }

    private String[] getDropInBundlesInfoPaths(String supportDir, String dropInsDirectories) {
        if (supportDir != null) {
            if (supportDir.startsWith("file:")) {
                supportDir = supportDir.substring(5);
            }
            String[] dropIns = dropInsDirectories.split(File.pathSeparator);
            ArrayList<String> paths = new ArrayList<String>();
            for (int i = dropIns.length - 1; i >= 0; --i) {
                String path = dropIns[i];
                String realPath = path.replace("/", File.separator);
                String bundlesInfoPath = supportDir + File.separator + OracleIdeLauncher.computeBundlesInfoName((String)realPath);
                if (!new File(bundlesInfoPath).exists()) continue;
                paths.add(bundlesInfoPath);
            }
            return paths.toArray(new String[paths.size()]);
        }
        return new String[0];
    }

    static {
        enabledModules.add("oracle.ide-osgi");
    }
}

