/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.timesten.TimesTen11g;
import oracle.javatools.db.timesten.TimesTen11gR2;
import oracle.javatools.db.timesten.TimesTenDatabase;

class TimesTenDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    TimesTenDDLGenerator(DBObjectProvider dBObjectProvider, Class<? extends TimesTenDatabase> clazz) {
        super(clazz, dBObjectProvider, TimesTenDDLGenerator.getBundles(clazz));
        if (TimesTen11g.class.isAssignableFrom(clazz)) {
            OracleDDLSupport oracleDDLSupport = OracleDDLSupport.getInstance();
            for (Map.Entry entry : oracleDDLSupport.getGlobalTokenGenerators().entrySet()) {
                this.registerTokenGenerator((String)entry.getKey(), (TokenGenerator)entry.getValue());
            }
            oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "SYNONYM", false);
            oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "SEQUENCE", false);
            oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "PACKAGE", false);
            oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "FUNCTION", false);
            oracleDDLSupport.includeOracleSyntax((TokenDDLGenerator)this, "PROCEDURE", false);
            this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        }
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        Collection<Object> collection = super.getAllowedPropertyValues(dBObject, dBObject2, string);
        if ("inline".equals(string) && dBObject2 instanceof Column) {
            String string2;
            DBObjectID dBObjectID;
            boolean bl = false;
            DataTypeUsage dataTypeUsage = ((Column)dBObject2).getDataTypeUsage();
            if (dataTypeUsage != null && (dBObjectID = dataTypeUsage.getDataTypeID()) instanceof DataTypeID && ((string2 = ((DataTypeID)dBObjectID).getTypeName()).matches(".*VARCHAR.*") || string2.matches(".*VARBINARY.*"))) {
                bl = true;
            }
            if (!bl) {
                collection = Collections.singleton(false);
            }
        } else if (string.equals("indexType")) {
            collection = Arrays.asList(Index.IndexType.NORMAL, Index.IndexType.UNIQUE);
        }
        return collection;
    }

    protected OracleDDLType getDDLType(String string) {
        return OracleDDLType.getDDLType((String)string);
    }

    private static String[] getBundles(Class<? extends TimesTenDatabase> clazz) {
        String[] stringArray = TimesTen11g.class.isAssignableFrom(clazz) || TimesTen11gR2.class.isAssignableFrom(clazz) ? new String[]{"/oracle/javatools/db/timesten/TimesTen7DDL.properties", "/oracle/javatools/db/timesten/TimesTen11gDDL.properties"} : new String[]{"/oracle/javatools/db/timesten/TimesTen7DDL.properties"};
        return stringArray;
    }
}

