/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.dbtools.jdbc.util.RestjdbcResources;

public class SQLStateMapping {
    static String mappingResource = "errorMap.json";

    public static String getSQLState(int errorCode) throws SQLException {
        try {
            InputStream s = SQLStateMapping.class.getResourceAsStream(mappingResource);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            JrsArray array = (JrsArray)json.treeFrom((Object)s).get("oraErrorSqlStateSqlExceptionMapping").get("error");
            for (int i = 0; i < array.size() - 1; ++i) {
                JrsValue elem = array.get(i);
                JrsString errorFromElem = (JrsString)elem.get("oraErrorFrom");
                String errorFromRep = errorFromElem.getValue();
                int oraErrorFrom = Integer.parseInt(errorFromRep);
                JrsString errorToElem = (JrsString)elem.get("oraErrorTo");
                if (errorToElem != null) {
                    String errorToRep = errorToElem.getValue();
                    int oraErrorTo = Integer.parseInt(errorToRep);
                    if (errorCode < oraErrorFrom || errorCode > oraErrorTo) continue;
                    return json.asString((Object)elem.get("sqlState"));
                }
                if (errorCode != oraErrorFrom) continue;
                return json.asString((Object)elem.get("sqlState"));
            }
        }
        catch (Exception e) {
            throw new SQLException(RestjdbcResources.getString("ORA_17001"), "99999", 17001);
        }
        throw new SQLException(RestjdbcResources.getString("ORA_17001"), "99999", 17001);
    }
}

